/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.loader.redis;

import cn.com.fishin.tuz.helper.LogHelper;
import cn.com.fishin.tuz.loader.redis.RedisConnection;
import cn.com.fishin.tuz.template.JedisTemplate;
import java.util.Map;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

public class DefaultRedisConnection
implements RedisConnection<String, String> {
    private JedisPool pool = null;

    public DefaultRedisConnection(JedisPool pool) {
        this.pool = pool;
    }

    @Override
    public String get(String key) {
        return new JedisTemplate<String>().execute(this.pool, jedis -> jedis.get(key));
    }

    @Override
    public boolean containsKey(String key) {
        return new JedisTemplate<Boolean>().execute(this.pool, jedis -> jedis.exists(key));
    }

    @Override
    public String put(String key, String value) {
        return new JedisTemplate<String>().execute(this.pool, jedis -> {
            jedis.set(key, value);
            return value;
        });
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        new JedisTemplate<Void>().execute(this.pool, jedis -> {
            Pipeline pipeline = jedis.pipelined();
            for (Map.Entry entry : map.entrySet()) {
                pipeline.set((String)entry.getKey(), (String)entry.getValue());
            }
            pipeline.sync();
            pipeline.close();
            return null;
        });
    }

    @Override
    public String remove(String key) {
        return new JedisTemplate<String>().execute(this.pool, jedis -> {
            jedis.del(key);
            return null;
        });
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.close();
            LogHelper.debug("JedisPool is closed ? " + this.pool.isClosed());
        }
    }
}

