/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.loader.json;

import cn.com.fishin.tuz.core.Loadable;
import cn.com.fishin.tuz.helper.LogHelper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractJSONLoader
implements Loadable {
    private Map<String, String> jsonMap = new HashMap<String, String>();

    @Override
    public Map<String, String> load() throws IOException {
        LogHelper.info("Load resource ===> " + this.jsonMap);
        return this.jsonMap;
    }

    protected AbstractJSONLoader(String jsonString) {
        this.parseJSONObject(JSON.parseObject((String)jsonString));
    }

    private void parseJSONObject(JSONObject jsonObject) {
        this.parseJSONObjectInternal(null, jsonObject);
    }

    private void parseJSONObjectInternal(Object key, Object value) {
        this.filledJsonMap(key, value);
        if (JSONObject.class.equals(value.getClass())) {
            JSONObject jsonObject = (JSONObject)value;
            for (Map.Entry entry : jsonObject.entrySet()) {
                Object k = entry.getKey();
                if (key != null) {
                    k = key + "." + k;
                }
                this.parseJSONObjectInternal(k, entry.getValue());
            }
            return;
        }
        if (JSONArray.class.equals(value.getClass())) {
            JSONArray jsonArray = (JSONArray)value;
            for (int i = 0; i < jsonArray.size(); ++i) {
                Object k = key;
                if (k != null) {
                    k = k + "[" + i + "]";
                }
                this.parseJSONObjectInternal(k, jsonArray.get(i));
            }
        }
    }

    private void filledJsonMap(Object key, Object value) {
        this.jsonMap.put(String.valueOf(key), String.valueOf(value));
    }
}

