/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.core;

import cn.com.fishin.tuz.core.Loadable;
import cn.com.fishin.tuz.core.TuzConfig;
import cn.com.fishin.tuz.helper.LogHelper;
import cn.com.fishin.tuz.template.LockTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Tuz {
    private static final Map<String, Map<String, String>> resources = new HashMap<String, Map<String, String>>();
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final Lock readLock = readWriteLock.readLock();
    private static final Lock writeLock = readWriteLock.writeLock();
    private static TuzConfig config = new TuzConfig();

    public static TuzConfig getConfig() {
        return config;
    }

    public static void setConfig(TuzConfig config) {
        Tuz.config = config;
    }

    public static void load(Loadable resource) throws Throwable {
        new LockTemplate<Void>().lockWith(writeLock, () -> {
            resources.put(resource.namespace(), resource.load());
            return null;
        });
        LogHelper.debug("Namespace [" + resource.namespace() + "] is loaded!");
    }

    public static void unLoad(Loadable resource) throws Throwable {
        Tuz.unLoad(resource.namespace());
    }

    public static void unLoad(String namespace) throws Throwable {
        new LockTemplate<Void>().lockWith(writeLock, () -> {
            if (resources.containsKey(namespace)) {
                resources.get(namespace).clear();
                resources.remove(namespace);
            }
            return null;
        });
        LogHelper.debug("Namespace [" + namespace + "] is unloaded!");
    }

    public static void reLoad(Loadable resource) throws Throwable {
        new LockTemplate<Void>().lockWith(writeLock, () -> {
            if (resources.containsKey(resource.namespace())) {
                resources.get(resource.namespace()).clear();
            }
            resources.put(resource.namespace(), resource.load());
            return null;
        });
        LogHelper.debug("Namespace [" + resource.namespace() + "] is reloaded!");
    }

    public static String use(String key, String namespace) {
        return Tuz.useGracefully(key, namespace, null);
    }

    public static String unUse(String key, String namespace) throws Throwable {
        return new LockTemplate<String>().lockWith(writeLock, () -> resources.containsKey(namespace) ? resources.get(namespace).remove(key) : null);
    }

    public static void appendResource(Map<String, String> resource, String namespace) throws Throwable {
        new LockTemplate<Void>().lockWith(writeLock, () -> {
            if (resources.containsKey(namespace)) {
                resources.get(namespace).putAll(resource);
                LogHelper.debug("Resource " + resource + " is appended to namespace [ " + namespace + " ] !");
            }
            return null;
        });
    }

    public static void appendResource(String key, String value, String namespace) throws Throwable {
        new LockTemplate<Void>().lockWith(writeLock, () -> {
            if (resources.containsKey(namespace)) {
                resources.get(namespace).put(key, value);
                LogHelper.debug("Resource {" + key + "=" + value + "} is appended to namespace [ " + namespace + " ] !");
            }
            return null;
        });
    }

    public static String useGracefully(String key, String namespace, String defaultValue) {
        try {
            return new LockTemplate<String>().lockWith(readLock, () -> resources.containsKey(namespace) ? resources.get(namespace).get(key) : defaultValue);
        }
        catch (Throwable t) {
            LogHelper.error(t.getMessage(), t);
            return defaultValue;
        }
    }

    public static String use(String key) {
        return Tuz.useGracefully(key, null);
    }

    public static String useGracefully(String key, String defaultValue) {
        try {
            return new LockTemplate<String>().lockWith(readLock, () -> {
                for (String namespace : resources.keySet()) {
                    Map<String, String> resource = resources.get(namespace);
                    if (!resource.containsKey(key)) continue;
                    return resource.get(key);
                }
                return defaultValue;
            });
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable.getMessage(), throwable);
            return defaultValue;
        }
    }

    public static void init() {
        try {
            new LockTemplate<Void>().lockWith(writeLock, () -> {
                config = new TuzConfig();
                return null;
            });
        }
        catch (Throwable t) {
            LogHelper.error(t.getMessage(), t);
        }
    }

    public static void destroy() {
        try {
            new LockTemplate<Void>().lockWith(writeLock, () -> {
                for (String namespace : resources.keySet()) {
                    resources.get(namespace).clear();
                }
                return null;
            });
        }
        catch (Throwable t) {
            LogHelper.error(t.getMessage(), t);
        }
    }
}

