/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.loader;

import cn.com.fishin.tuz.core.Loadable;
import cn.com.fishin.tuz.helper.LogHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractPropertiesLoader
implements Loadable {
    protected abstract Properties loadProperties() throws IOException;

    protected AbstractPropertiesLoader() {
    }

    @Override
    public Map<String, String> load() throws IOException {
        return this.properties2Map(this.loadProperties());
    }

    private int sizeOfPropertiesKey(Properties properties) {
        return properties.stringPropertyNames().size();
    }

    private Map<String, String> properties2Map(Properties properties) {
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>(this.sizeOfPropertiesKey(properties) * 2);
        for (String key : properties.stringPropertyNames()) {
            result.put(key, properties.getProperty(key));
        }
        LogHelper.debug(properties + " <=== (Properties to Map) ===> " + result);
        return result;
    }
}

