/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.core;

import cn.com.fishin.tuz.core.Loadable;
import cn.com.fishin.tuz.core.TuzConfig;
import cn.com.fishin.tuz.helper.LogHelper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Tuz {
    private static final Map<String, Map<String, String>> resources = new ConcurrentHashMap<String, Map<String, String>>();
    private static TuzConfig config = new TuzConfig();

    public static TuzConfig getConfig() {
        return config;
    }

    public static void setConfig(TuzConfig config) {
        Tuz.config = config;
    }

    public static void load(Loadable resource) throws IOException {
        resources.put(resource.namespace(), resource.load());
        LogHelper.debug("Namespace [" + resource.namespace() + "] is loaded!");
    }

    public static void unLoad(Loadable resource) {
        Tuz.unLoad(resource.namespace());
    }

    public static void unLoad(String namespace) {
        resources.remove(namespace);
        LogHelper.debug("Namespace [" + namespace + "] is unloaded!");
    }

    public static void reLoad(Loadable resource) throws IOException {
        resources.put(resource.namespace(), resource.load());
        LogHelper.debug("Namespace [" + resource.namespace() + "] is reloaded!");
    }

    public static String use(String key, String namespace) {
        return Tuz.useGracefully(key, namespace, null);
    }

    public static String unUse(String key, String namespace) {
        return resources.containsKey(namespace) ? resources.get(namespace).remove(key) : null;
    }

    public static void appendResource(Map<String, String> resource, String namespace) {
        if (resources.containsKey(namespace)) {
            resources.get(namespace).putAll(resource);
            LogHelper.debug("Resource " + resource + " is appended to namespace [ " + namespace + " ] !");
        }
    }

    public static void appendResource(String key, String value, String namespace) {
        if (resources.containsKey(namespace)) {
            resources.get(namespace).put(key, value);
            LogHelper.debug("Resource {" + key + "=" + value + "} is appended to namespace [ " + namespace + " ] !");
        }
    }

    public static String useGracefully(String key, String namespace, String defaultValue) {
        return resources.containsKey(namespace) ? resources.get(namespace).get(key) : defaultValue;
    }

    public static String use(String key) {
        return Tuz.useGracefully(key, null);
    }

    public static String useGracefully(String key, String defaultValue) {
        for (String namespace : resources.keySet()) {
            Map<String, String> resource = resources.get(namespace);
            if (!resource.containsKey(key)) continue;
            return resource.get(key);
        }
        return defaultValue;
    }

    public static void init() {
        config = new TuzConfig();
    }
}

