/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.plugin;

import cn.com.fishin.tuz.core.Tuz;
import cn.com.fishin.tuz.factory.ProxyFactory;
import cn.com.fishin.tuz.handler.InterceptorInvocationHandler;
import cn.com.fishin.tuz.helper.LogHelper;
import cn.com.fishin.tuz.interceptor.Interceptor;
import cn.com.fishin.tuz.plugin.DiPlugin;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ProxyPlugin {
    private static final Map<String, Object> proxyInstances = new ConcurrentHashMap<String, Object>(32);
    private static final Lock newProxyInstanceLock = new ReentrantLock();

    public static <T> T useInstance(String key, Class<T> classType, Interceptor[] interceptors) {
        return ProxyPlugin.useInstanceInternal(DiPlugin.useInstance(key, classType), classType, interceptors);
    }

    public static <T> T useInstance(String key, String namespace, Class<T> classType, Interceptor[] interceptors) {
        return ProxyPlugin.useInstanceInternal(DiPlugin.useInstance(key, namespace, classType), classType, interceptors);
    }

    public static <T> T useInstance(Class<T> classType, Interceptor[] interceptors) {
        return ProxyPlugin.useInstanceInternal(DiPlugin.useInstance(classType), classType, interceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T singletonProxyInstance(Object target, Class<T> classType, Interceptor[] interceptors) {
        newProxyInstanceLock.lock();
        try {
            if (!proxyInstances.containsKey(classType.getName())) {
                Object t = ProxyFactory.wrap(target, new InterceptorInvocationHandler(target, interceptors));
                LogHelper.info("Proxy instance created ===> " + classType.getName());
                proxyInstances.put(classType.getName(), t);
            }
        }
        finally {
            newProxyInstanceLock.unlock();
        }
        return (T)proxyInstances.get(classType.getName());
    }

    private static <T> T useInstanceInternal(Object target, Class<T> classType, Interceptor[] interceptors) {
        if (Tuz.getConfig().isSingleton()) {
            return ProxyPlugin.singletonProxyInstance(target, classType, interceptors);
        }
        LogHelper.info("Proxy instance created ===> " + classType.getName());
        return (T)ProxyFactory.wrap(target, new InterceptorInvocationHandler(target, interceptors));
    }
}

