/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.helper;

import cn.com.fishin.tuz.helper.LogHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class IOHelper {
    public static Reader newReader(Path path, Charset charset) throws IOException {
        return Files.newBufferedReader(path, charset);
    }

    public static Reader newReaderToFileSystem(String path, Charset charset) throws IOException {
        return IOHelper.newReader(IOHelper.getResourceFromFileSystem(path), charset);
    }

    public static Reader newReaderToClasspath(String path, Charset charset) throws IOException {
        return IOHelper.newReader(IOHelper.getResourceFromClasspath(path), charset);
    }

    public static Path getResourceFromClasspath(String resource) {
        URL url = IOHelper.class.getClassLoader().getResource(resource);
        try {
            if (url == null) {
                throw new FileNotFoundException(resource + " is not found in classpath!");
            }
            return Paths.get(url.toURI());
        }
        catch (FileNotFoundException | URISyntaxException e) {
            LogHelper.error(e.getMessage(), e);
            return null;
        }
    }

    public static Path getResourceFromFileSystem(String resource) {
        return Paths.get(resource, new String[0]);
    }
}

