package cn.com.ecarx.gcountly.opensdk;

import android.app.Activity;
import android.content.Context;

import java.util.Map;

/**
 * Created by zhanghao.
 * 2017/5/18-11:09
 */

public interface ICount extends IRecordEvent {

    void init(Context context, String serverUrl, String appKey);

    void init(Context context, String serverUrl, String appKey, String deviceId);

    boolean isInitialized();

    void onCreate(Activity activity);

    void onStart(Activity activity);

    void onStop();

    void setViewTracking(boolean enable);

    boolean isViewTrackingEnabled();

    void recordView(String viewName);

    void setUserData(Map<String, String> data);

    void setUserData(Map<String, String> data, Map<String, String> customdata);

    void setCustomUserData(Map<String, String> customdata);

    void setLocation(double lat, double lon);

    /**
     * Sets custom segments to be reported with crash reports
     * In custom segments you can provide any string key values to segments crashes by
     *
     * @param segments Map&lt;String, String&gt; key segments and their values
     */
    void setCustomCrashSegments(Map<String, String> segments);

    /**
     * Add crash breadcrumb like log record to the log that will be send together with crash report
     *
     * @param record String a bread crumb for the crash report
     */
    void addCrashLog(String record);

    /**
     * Log handled exception to report it to server as non fatal crash
     *
     * @param exception Exception to log
     */
    void logException(Exception exception);

    /**
     * Enable crash reporting to send unhandled crash reports to server
     */
    void enableCrashReporting();

    /**
     * Start timed event with a specified key
     *
     * @param key name of the custom event, required, must not be the empty string or null
     * @return true if no event with this key existed before and event is started, false otherwise
     */
    boolean startEvent(String key);

    /**
     * End timed event with a specified key
     *
     * @param key name of the custom event, required, must not be the empty string or null
     * @return true if event with this key has been previously started, false otherwise
     */
    boolean endEvent(String key);

    /**
     * End timed event with a specified key
     *
     * @param key          name of the custom event, required, must not be the empty string
     * @param segmentation segmentation dictionary to associate with the event, can be null
     * @param count        count to associate with the event, should be more than zero
     * @param sum          sum to associate with the event
     * @return true if event with this key has been previously started, false otherwise
     * @throws IllegalStateException    if void SDK has not been initialized
     * @throws IllegalArgumentException if key is null or empty, count is less than 1, or if
     *                                  segmentation contains null or empty keys or values
     */
    boolean endEvent(String key, Map<String, String> segmentation, int count, double sum);

    /**
     * Disable periodic session time updates.
     * By default, void will send a request to the server each 30 seconds with a small update
     * containing session duration time. This method allows you to disable such behavior.
     * Note that event updates will still be sent every 10 events or 30 seconds after event recording.
     *
     * @param disable whether or not to disable session time updates
     *  void instance for easy method chaining
     */
    void setDisableUpdateSessionRequests(boolean disable);

    boolean isLoggingEnabled();

    /**
     * Sets whether debug logging is turned on or off. Logging is disabled by default.
     *
     * @param enableLogging true to enable logging, false to disable logging
     *  void instance for easy method chaining
     */
    void setLoggingEnabled(boolean enableLogging);

    void enableParameterTamperingProtection(String salt);

    void setEventQueueSizeToSend(int size);

    void halt();

    void changeDeviceId(String deviceId);
}
