package cn.com.ecarx.gcountly.opensdk;

/**
 * Created by zhanghao.
 * 2017/5/18-10:18
 */

public class GCountlyConfig {

    private String serverUrl;
    private String appKey;
    private boolean isLogEnable;
    private String deviceId;
    private ICount realCount;

    private GCountlyConfig(String serverUrl, String appKey, boolean isLogEnable, String deviceId, ICount realCount) {
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.isLogEnable = isLogEnable;
        this.deviceId = deviceId;
        this.realCount = realCount;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public ICount getRealCount() {
        return realCount;
    }

    public void setRealCount(ICount realCount) {
        this.realCount = realCount;
    }

    public boolean isLogEnable() {
        return isLogEnable;
    }

    public void setLogEnable(boolean logEnable) {
        isLogEnable = logEnable;
    }

    public static class Builder {

        private String serverUrl;
        private String appKey;
        private ICount iCount;
        private String deviceId;
        private boolean isLogEnable;

        public Builder setAppServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder setAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder setRealCount(ICount realCount) {
            this.iCount = realCount;
            return this;
        }

        public Builder setLogEnable(boolean isEnable) {
            this.isLogEnable = isEnable;
            return this;
        }

        public Builder setDeciceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public GCountlyConfig builder() {
            return new GCountlyConfig(serverUrl, appKey, isLogEnable, deviceId, iCount);
        }

    }
}
