package cn.com.ecarx.gcountly.opensdk;

import android.app.Activity;
import android.content.Context;

import java.util.Map;

/**
 * Created by zhanghao.
 * 2017/5/18-10:10
 */

public class GCountly {

    private GCountlyConfig GCountlyConfig;
    private ICount iCount;

    public static GCountly getInstance() {
        return SingletonHolder.instance;
    }

    private GCountly() {
    }

    private static class SingletonHolder {
        static GCountly instance = new GCountly();
    }

    public void init(Context context, GCountlyConfig gCountlyConfig) {
        this.GCountlyConfig = gCountlyConfig;
        this.iCount = gCountlyConfig.getRealCount();
        if (iCount == null) {
            iCount = new CountlyWrap();
        }
        iCount.setLoggingEnabled(gCountlyConfig.isLogEnable());
        iCount.init(context, gCountlyConfig.getServerUrl(), gCountlyConfig.getAppKey(), gCountlyConfig.getDeviceId());
    }

    public void init(Context context, String serverUrl, String appKey, String deviceId) {
        GCountlyConfig config = new GCountlyConfig.Builder().builder();
        config.setAppKey(appKey);
        config.setServerUrl(serverUrl);
        config.setDeviceId(deviceId);
        this.init(context, config);
    }

    public void recordEvent(String key) {
        iCount.recordEvent(key);
    }

    public void recordEvent(String key, int count) {
        iCount.recordEvent(key, count);
    }

    public void recordEvent(String key, int count, double sum) {
        iCount.recordEvent(key, count, sum);
    }

    public void recordEvent(String key, Map<String, String> segmentation, int count) {
        iCount.recordEvent(key, segmentation, count);
    }

    public void recordEvent(String key, Map<String, String> segmentation, int count, double sum) {
        iCount.recordEvent(key, segmentation, count, sum);
    }

    public void recordEvent(String key, Map<String, String> segmentation, int count, double sum, double dur) {
        iCount.recordEvent(key, segmentation, count, sum, dur);
    }

    public void onCreate(Activity activity) {
        iCount.onCreate(activity);
    }

    public void onStart(Activity activity) {
        iCount.onStart(activity);
    }

    public void onStop() {
        iCount.onStop();
    }

    public void setViewTracking(boolean enable) {
        iCount.setViewTracking(enable);
    }

    public boolean isViewTrackingEnabled() {
        return iCount.isViewTrackingEnabled();
    }

    public void recordView(String viewName) {
        iCount.recordView(viewName);
    }

    public void setUserData(Map<String, String> data) {
        iCount.setUserData(data);
    }

    public void setUserData(Map<String, String> data, Map<String, String> customdata) {
        iCount.setUserData(data, customdata);
    }

    public void setCustomUserData(Map<String, String> customdata) {
        iCount.setCustomUserData(customdata);
    }

    public void setLocation(double lat, double lon) {
        iCount.setLocation(lat, lon);
    }

    /**
     * Sets custom segments to be reported with crash reports
     * In custom segments you can provide any string key values to segments crashes by
     *
     * @param segments Map&lt;String, String&gt; key segments and their values
     */
    public void setCustomCrashSegments(Map<String, String> segments) {
        iCount.setCustomCrashSegments(segments);
    }

    /**
     * Add crash breadcrumb like log record to the log that will be send together with crash report
     *
     * @param record String a bread crumb for the crash report
     */
    public void addCrashLog(String record) {
        iCount.addCrashLog(record);
    }

    /**
     * Log handled exception to report it to server as non fatal crash
     *
     * @param exception Exception to log
     */
    public void logException(Exception exception) {
        iCount.logException(exception);
    }

    /**
     * Enable crash reporting to send unhandled crash reports to server
     */
    public void enableCrashReporting() {
        iCount.enableCrashReporting();
    }

    /**
     * Start timed event with a specified key
     *
     * @param key name of the custom event, required, must not be the empty string or null
     * @return true if no event with this key existed before and event is started, false otherwise
     */
    public boolean startEvent(String key) {
        return iCount.startEvent(key);
    }

    /**
     * End timed event with a specified key
     *
     * @param key name of the custom event, required, must not be the empty string or null
     * @return true if event with this key has been previously started, false otherwise
     */
    public boolean endEvent(String key) {
        return iCount.endEvent(key);
    }

    /**
     * End timed event with a specified key
     *
     * @param key          name of the custom event, required, must not be the empty string
     * @param segmentation segmentation dictionary to associate with the event, can be null
     * @param count        count to associate with the event, should be more than zero
     * @param sum          sum to associate with the event
     * @return true if event with this key has been previously started, false otherwise
     * @throws IllegalStateException    if ICount SDK has not been initialized
     * @throws IllegalArgumentException if key is null or empty, count is less than 1, or if
     *                                  segmentation contains null or empty keys or values
     */
    public boolean endEvent(String key, Map<String, String> segmentation, int count, double sum) {
        return iCount.endEvent(key, segmentation, count, sum);
    }

    /**
     * Disable periodic session time updates.
     * By default, ICount will send a request to the server each 30 seconds with a small update
     * containing session duration time. This method allows you to disable such behavior.
     * Note that event updates will still be sent every 10 events or 30 seconds after event recording.
     *
     * @param disable whether or not to disable session time updates
     *                instance for easy method chaining
     */
    public void setDisableUpdateSessionRequests(boolean disable) {
        iCount.setDisableUpdateSessionRequests(disable);
    }

    public void enableParameterTamperingProtection(String salt) {
        iCount.enableParameterTamperingProtection(salt);
    }

    public void setLoggingEnabled(boolean enableLogging) {
        iCount.setLoggingEnabled(enableLogging);
    }

    public boolean isLoggingEnabled() {
        return iCount.isLoggingEnabled();
    }

    public void setEventQueueSizeToSend(int size) {
        iCount.setEventQueueSizeToSend(size);
    }

    /**
     * Immediately disables session &amp; event tracking and clears any stored session &amp; event data.
     * This API is useful if your app has a tracking opt-out switch, and you want to immediately
     * disable tracking when a user opts out. The onStart/onStop/recordEvent methods will throw
     * IllegalStateException after calling this until Countly is reinitialized by calling init
     * again.
     */
    public void halt() {
        iCount.halt();
    }

    /**
     * Changes current device id to the one specified in parameter. Merges user profile with new id
     * (if any) with old profile.
     *
     * @param deviceId new device id
     */
    public void changeDeviceId(String deviceId) {
        iCount.changeDeviceId(deviceId);
    }
}
