package cn.com.broadlink.tool.libs.ui.activity;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;

import cn.com.broadlink.tool.libs.db.BLBaseDBHelper;
import cn.com.broadlink.tool.libs.db.BLDBHelperManger;
import cn.com.broadlink.tool.libs.ui.BLBaseApplication;
import cn.com.broadlink.tool.libs.ui.activity.swipe.SwipeBackActivity;

public class BLBaseActivity extends SwipeBackActivity {
    public BLBaseApplication mApplication;

    public SystemBarTintManager mSystemBarTintManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        mApplication = (BLBaseApplication) getApplication();
        super.onCreate(savedInstanceState);

        initSystemBar();

        setSwipeBackEnable(false);
    }
    
//    @Override
//    protected void onDestroy() {
//        super.onDestroy();
//        BLDBHelperManger.getInstance().releaseDBHelper();
//    }

    /**
     * 获取DB Helper
     * @param clazz
     * @param <T>
     * @return
     */
    public <T extends BLBaseDBHelper> T getHelper(Class<T> clazz) {
        return BLDBHelperManger.getInstance().getHelper(this, clazz);
    }

    private void initSystemBar(){
        mSystemBarTintManager = new SystemBarTintManager(this);
        mSystemBarTintManager.setStatusBarTintEnabled(true);

        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT){
            if (mSystemBarTintManager.isStatusBarAvailable()) {
                mSystemBarTintManager.setStatusBarTintColor(Color.TRANSPARENT);
            }
        }
    }

    /**
     * 退出Activity
     */
    protected void back() {
        finish();
    }

    @Override
    public Resources getResources() {
        Resources res = super.getResources();
        Configuration config = new Configuration();
        config.setToDefaults();
        res.updateConfiguration(config,res.getDisplayMetrics() );
        return res;
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        back();
    }
}
