package cn.com.broadlink.tool.libs.ui;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Environment;

import net.sqlcipher.database.SQLiteDatabase;

import java.io.File;
import java.lang.reflect.Field;

import cn.com.broadlink.tool.libs.common.BLAppUtils;
import cn.com.broadlink.tool.libs.common.BLCrashUtils;
import cn.com.broadlink.tool.libs.constants.BLSettings;

/**
 * <pre>
 * BaseBLApplication
 * @author YeJing
 * @data 2018/6/22
 * </pre>
 */

public class BLBaseApplication extends Application{

	@Override
	public void onCreate() {
		super.onCreate();

		init();
	}

	/** 应用初始化**/
	private void init() {
		SQLiteDatabase.loadLibs(this);

		BLAppUtils.init(this);

		BLCrashUtils.init();

		initAppInfo();
	}

	public void exitApp(){
		BLAppUtils.exitApp();
	}

	/**
	 * <br>1.获取手机屏幕高宽
	 * <br>2.APP各个目录创建
	 */
	private void initAppInfo() {
		queryPhoneWindowInfo();

		initBaseDirectory(this);
	}

	public static void initBaseDirectory(Context context) {
		String rootPath = null;
		// 存在SDCARD的时候，路径设置到SDCARD
		if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())) {
			rootPath = Environment.getExternalStorageDirectory().getPath();
			// 不存在SDCARD的时候，路径设置到ROM
		}else{
			rootPath = context.getCacheDir().getAbsolutePath();
		}

		File dataDir = new File(new File(rootPath, "Android"), "data");
		File appDir = new File(dataDir, context.getPackageName());
		appDir.mkdirs();

		BLSettings.BASE_PATH = appDir.getAbsolutePath();
	}

	/**
	 * 获取手机屏幕信息
	 **/
	private void queryPhoneWindowInfo() {
		// 获得屏幕高度（像素）
		BLSettings.P_HEIGHT = getResources().getDisplayMetrics().heightPixels;
		// 获得屏幕宽度（像素）
		BLSettings.P_WIDTH = getResources().getDisplayMetrics().widthPixels;

		//判断是不是手机被横屏之后，设备宽高获取错误。
		if (BLSettings.P_HEIGHT < BLSettings.P_WIDTH) {
			int temp = BLSettings.P_HEIGHT;
			BLSettings.P_HEIGHT = BLSettings.P_WIDTH;
			BLSettings.P_WIDTH = temp;
		}

		BLSettings.STATUS_HEIGHT = getStatusBarHeight();
		BLSettings.NAVIGATION_HEIGHT = getNavigationBarHeight();
	}

	private int getNavigationBarHeight() {
		Resources resources = getResources();
		int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
		return resources.getDimensionPixelSize(resourceId);
	}

	//获取状态栏高度
	private int getStatusBarHeight() {
		try {
			Class<?> cls = Class.forName("com.android.internal.R$dimen");
			Object obj = cls.newInstance();
			Field field = cls.getField("status_bar_height");
			int x = Integer.parseInt(field.get(obj).toString());
			return getResources().getDimensionPixelSize(x);
		} catch (Exception e) {}
		return 0;
	}
}
