package cn.com.broadlink.tool.libs.httplib;

import android.content.Context;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import cn.com.broadlink.tool.libs.common.BLLogUtils;
import cn.com.broadlink.tool.libs.httplib.data.BLDownloadParameter;

public class BLDownLoadAccessser extends HttpBaseAccessor {

    private static final String TAG = BLDownLoadAccessser.class.getName();

    private OnProgressListener mOnProgressListener;

    private int mInterval;

    /**
     * 构造函数
     */
    public BLDownLoadAccessser(Context context) {
        super(context, HttpBaseAccessor.METHOD_GET);
    }

    public BLDownLoadAccessser(Context context, int method) {
        super(context, method);
    }
    
    /**
     * 
     * @param url
     *           请求URL
     * @param headParam
     *          网络请求头参数
     * @param requestParam
     *          请求参数
     * @param param
     *            参数
     * @return 数据结果
     */
    public Boolean execute(String url, Object headParam, Object requestParam, BLDownloadParameter param){
        try {
            return access(url, headParam, requestParam, param);
        } catch (Exception e) {
            onException(e);
        }
        return null;
    }
    
    /**
     * 
     * @param url
     * 			 请求URL
     * @param requestParam
     * 			请求参数
     * @param param
     * 			  参数
     * @return 数据结果
     */
    public Boolean execute(String url, Object requestParam , BLDownloadParameter param){
        try {
            return access(url, null, requestParam, param);
        } catch (Exception e) {
            onException(e);
        }
        return null;
    }

    private HttpResponse mHttpResponse;
    /**
     * 连接服务端开始通信
     * 
     * @param url
     *            请求URL
     *            
     *  @param headParam
     *            Header参数
     *            
     * @param param
     *            参数
     * 
     * @return 结果
     */
    protected Boolean access(String url, Object headParam, Object requestParam , BLDownloadParameter param) throws Exception {
        File tempFile = new File(param.getTempFilePath());
        tempFile.getParentFile().mkdirs();
        File file = new File(param.getSaveFilePath());
        file.getParentFile().mkdirs();

        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            long startTime = System.currentTimeMillis();

            if (mMethod == METHOD_POST) {
                mHttpRequest = new HttpPost();
            } else {
                mHttpRequest = new HttpGet();
            }

            setHttpHeadParam(headParam);
            
            url = addBodyParam(requestParam, url);
            
//			if (requestParam != null) {
//				List<Field> fields = DataParseUtils.getFields(requestParam.getClass(), Object.class);
//				if (mMethod == METHOD_POST) {
//					List<NameValuePair> params = new ArrayList<NameValuePair>();
//
//					for (Field field : fields) {
//						field.setAccessible(true);
//						if (field.get(requestParam) != null) {
//							params.add(new BasicNameValuePair(field.getName(), String.valueOf(field.get(requestParam))));
//						}
//					}
//
//					UrlEncodedFormEntity formEntiry = new UrlEncodedFormEntity(params, HTTP.UTF_8);
//
//					((HttpPost) mHttpRequest).setEntity(formEntiry);
//				}
//			}
            
            mHttpRequest.setURI(new URI(url));

            HttpClient httpClient = getHttpClient();
            mHttpResponse = httpClient.execute(mHttpRequest);

            if (mHttpResponse.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                long progress = 0;
                long total = mHttpResponse.getEntity().getContentLength();
                if (mOnProgressListener != null && mInterval > 0)
                    mOnProgressListener.onProgress(progress, total);

                bis = new BufferedInputStream(mHttpResponse.getEntity().getContent());

                tempFile.createNewFile();

                bos = new BufferedOutputStream(new FileOutputStream(tempFile));

                int size;
                byte[] temp = new byte[1024];
                while ((size = bis.read(temp, 0, temp.length)) != -1 && !mStoped) {
                    bos.write(temp, 0, size);

                    progress += size;

                    if (mOnProgressListener != null && mInterval > 0) {
                        long now = System.currentTimeMillis();
                        if (now - startTime >= mInterval) {
                            mOnProgressListener.onProgress(progress, total);
                            startTime = now;
                        }
                    }
                }

                bos.flush();
                bos.close();
                bos = null;

                if (mStoped)
                    return false;

                return tempFile.renameTo(file);

            } else {
                throw new SocketException("Status Code : "  + mHttpResponse.getStatusLine().getStatusCode());
            }

        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    BLLogUtils.e(TAG, e.getMessage(), e);
                }
                bos = null;
            }
            if (bis != null) {
                try {
                    bis.close();
                } catch (IOException e) {
                    BLLogUtils.e(TAG, e.getMessage(), e);
                }
                bis = null;
            }
        }
    }

    public HttpResponse getHttpResponse() {
        return mHttpResponse;
    }

    //设置Http 请求头信息
    private void setHttpHeadParam(Object headParam) throws Exception {
        if(headParam != null){
            List<Field> headfields = DataParseUtils.getFields(headParam.getClass(), Object.class);
            for (Field field : headfields) {
                field.setAccessible(true);
                if (field.get(headParam) != null) {
                    mHttpRequest.addHeader(field.getName(), String.valueOf(field.get(headParam)));
                }
            }
        }
    }
    
    
    /***
     * 设置http Entity
     * 
     * @param   param    
     * 
     * @param   url   
     *          请求的URL，Http Get请求将参数拼接到url上面
     * 
     * @return String url
     *             http URL
     *
     */
    private String addBodyParam(Object param, String url) throws Exception {
        if (param != null) {
            if(param instanceof String){
                ((HttpPost) mHttpRequest).setEntity(new StringEntity((String) param, HTTP.UTF_8));
            }else if(param instanceof byte[]){
                ((HttpPost) mHttpRequest).setEntity(new ByteArrayEntity((byte[]) param));
            }else{
                List<Field> fields = DataParseUtils.getFields(param.getClass(), Object.class);

                switch (mMethod) {
                case METHOD_POST:
                    List<NameValuePair> params = new ArrayList<NameValuePair>();

                    for (Field field : fields) {
                        field.setAccessible(true);
                        if (field.get(param) != null) {
                            params.add(new BasicNameValuePair(field.getName(), String.valueOf(field
                                    .get(param))));
                        }
                    }

                    UrlEncodedFormEntity formEntiry = new UrlEncodedFormEntity(params, HTTP.UTF_8);

                    ((HttpPost) mHttpRequest).setEntity(formEntiry);

                    break;

                case METHOD_GET:
                    StringBuilder sbUrl = new StringBuilder();

                    for (Field field : fields) {
                        field.setAccessible(true);
                        if (field.get(param) != null) {
                            sbUrl.append('&');
                            sbUrl.append(field.getName());
                            sbUrl.append('=');
                            sbUrl.append(String.valueOf(field.get(param)));
                        }
                    }

                    if (sbUrl.length() > 0) {
                        sbUrl.replace(0, 1, "?");
                        url += sbUrl.toString();
                    }

                    break;
                }
            }
        }
        return url;
    }

    protected void onException(Exception e) {
        BLLogUtils.e(TAG, e.getMessage(), e);
    }

    public void setOnProgressListener(OnProgressListener onProgressListener, int interval) {
        this.mOnProgressListener = onProgressListener;
        this.mInterval = interval;
    }

    public OnProgressListener getOnProgressListener() {
        return mOnProgressListener;
    }

    public void setInterval(int interval) {
        this.mInterval = interval;
    }

    public int getInterval() {
        return mInterval;
    }

    public interface OnProgressListener {

        public void onProgress(long progress, long total);
    }
}