package cn.com.broadlink.tool.libs.db;

import android.content.Context;

import com.j256.ormlite.android.apptools.OpenHelperManager;


/**
 * IHC 管理 DB 只允许保持有一个DB连接
 * @author YeJing
 * @data 2017/12/23
 */

public class BLDBHelperManger {
	//DB Helper
	private volatile BLBaseDBHelper mHelper;

	private static BLDBHelperManger mDBHelperManger;

	//单例
	public static BLDBHelperManger getInstance(){
		synchronized (BLDBHelperManger.class){
			if(mDBHelperManger == null){
				mDBHelperManger = new BLDBHelperManger();
			}
		}
		return mDBHelperManger;
	}

	/**
	 * 获取DB Helper
	 * @param context
	 * 			 上下文
	 * @param clazz
	 * 			OrmLiteSqliteOpenHelper class
	 * @param <T>
	 *     		DB Helper 对象
	 * @return
	 */
	public synchronized <T extends BLBaseDBHelper> T getHelper(Context context, Class<T> clazz) {
		if (mHelper == null) {
			mHelper = OpenHelperManager.getHelper(context, clazz);
		}else if(!mHelper.isOpen() || mHelper.getClass() != clazz){ //判断当前的DB Helper是否和要获取的为同一个，不是的话释放上一个
			releaseDBHelper();
			//重新加载新的DB Helper
			mHelper = OpenHelperManager.getHelper(context, clazz);
		}
		return (T) mHelper;
	}

	/**
	 * 释放 DB Helper
	 */
	public synchronized void releaseDBHelper(){
		if(mHelper != null){
			OpenHelperManager.releaseHelper();
			OpenHelperManager.setOpenHelperClass(null);
			mHelper = null;
		}
	}
}
