package cn.com.broadlink.tool.libs.common;

import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import android.util.Log;

import java.util.List;

public class BLWifiManager {
    private WifiManager mWifiManager = null;

    // 定义几种加密方式，一种是WEP，一种是WPA，还有没有密码的情况
    public enum WifiCipherType {
        WIFICIPHER_WEP, WIFICIPHER_WPA, WIFICIPHER_NOPASS, WIFICIPHER_INVALID
    }

    // 构造函数
    public BLWifiManager(WifiManager wifiManager) {
        this.mWifiManager = wifiManager;
    }

    public WifiManager wifiManager(){
        return mWifiManager;
    }

    public boolean connectWIFI(ScanResult scanResult){
        return connectWIFI(scanResult.SSID, null, wifiCipherType(scanResult));
    }

    public boolean connectWIFI(String ssid, String passwrod, WifiCipherType type){
        openWifi();

        while (wifiManager().getWifiState() == WifiManager.WIFI_STATE_ENABLING) {
            try {
                // 为了避免程序一直while循环，让它睡个100毫秒检测……
                Thread.sleep(200);
            } catch (InterruptedException ie) {
                Log.e("wifidemo", ie.toString());
            }
        }

        //禁掉所有之前连接过的wifi，防止重连到之前的wifi
        for (WifiConfiguration c : wifiManager().getConfiguredNetworks()) {
            wifiManager().disableNetwork(c.networkId);
        }

        //获取SSID 之前是否连接过
        WifiConfiguration configurationed = isConfiguredSSID(ssid);
        if(configurationed != null){
            return wifiManager().enableNetwork(configurationed.networkId, true);
        }else{
            WifiConfiguration configuration = createWifiInfo(ssid, passwrod, type);
            int netID = wifiManager().addNetwork(configuration);
            return wifiManager().enableNetwork(netID, true);
        }
    }

    // 查看以前是否也配置过这个网络
    public WifiConfiguration isConfiguredSSID(String SSID) {
        List<WifiConfiguration> existingConfigs = mWifiManager.getConfiguredNetworks();
        for (WifiConfiguration existingConfig : existingConfigs) {
            if (existingConfig.SSID.equals("\"" + SSID + "\"")) {
                return existingConfig;
            }
        }
        return null;
    }

    /**
     * 创建wifi配置文件
     * @param SSID
     * @param Password
     * @param Type
     * @return
     */
    public WifiConfiguration createWifiInfo(String SSID, String Password, WifiCipherType Type) {
        WifiConfiguration config = new WifiConfiguration();
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        config.SSID = "\"" + SSID + "\"";
        // config.SSID = SSID;
        // nopass
        if (Type == WifiCipherType.WIFICIPHER_NOPASS) {
            // config.wepKeys[0] = "";
            config.allowedKeyManagement.set(WifiConfiguration.KeyMgmt.NONE);
            // config.wepTxKeyIndex = 0;
        } else if (Type == WifiCipherType.WIFICIPHER_WEP) {// wep
            if (!TextUtils.isEmpty(Password)) {
                if (isHexWepKey(Password)) {
                    config.wepKeys[0] = Password;
                } else {
                    config.wepKeys[0] = "\"" + Password + "\"";
                }
            }
            config.allowedAuthAlgorithms.set(WifiConfiguration.AuthAlgorithm.OPEN);
            config.allowedAuthAlgorithms.set(WifiConfiguration.AuthAlgorithm.SHARED);
            config.allowedKeyManagement.set(WifiConfiguration.KeyMgmt.NONE);
            config.wepTxKeyIndex = 0;
        } else if (Type == WifiCipherType.WIFICIPHER_WPA) {// wpa
            config.preSharedKey = "\"" + Password + "\"";
            config.allowedAuthAlgorithms.set(WifiConfiguration.AuthAlgorithm.OPEN);
            config.allowedGroupCiphers.set(WifiConfiguration.GroupCipher.TKIP);
            config.allowedGroupCiphers.set(WifiConfiguration.GroupCipher.CCMP);
            config.allowedKeyManagement.set(WifiConfiguration.KeyMgmt.WPA_PSK);
            config.allowedPairwiseCiphers.set(WifiConfiguration.PairwiseCipher.TKIP);
            config.allowedPairwiseCiphers.set(WifiConfiguration.PairwiseCipher.CCMP);
            config.allowedProtocols.set(WifiConfiguration.Protocol.RSN);
            config.allowedProtocols.set(WifiConfiguration.Protocol.WPA);
            config.status = WifiConfiguration.Status.ENABLED;
        }
        return config;
    }

    private boolean isHexWepKey(String wepKey) {
        final int len = wepKey.length();
        // WEP-40, WEP-104, and some vendors using 256-bit WEP (WEP-232?)
        if (len != 10 && len != 26 && len != 58) {
            return false;
        }
        return isHex(wepKey);
    }

    private boolean isHex(String key) {
        for (int i = key.length() - 1; i >= 0; i--) {
            final char c = key.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a'
                    && c <= 'f')) {
                return false;
            }
        }
        return true;
    }

    /**获取wifi加密方式**/
    public WifiCipherType wifiCipherType(ScanResult scanResult){
        String capabilities = scanResult.capabilities;
        return wifiCipherType(capabilities);
    }

    public WifiCipherType wifiCipherType(String capabilities){
        if (!TextUtils.isEmpty(capabilities)) {
            if (capabilities.contains("WPA")  || capabilities.contains("wpa")) {
                Log.e("wifidemo", "wpa");
                return WifiCipherType.WIFICIPHER_WPA;
            } else if (capabilities.contains("WEP") || capabilities.contains("wep")) {
                Log.e("wifidemo", "wep");
                return WifiCipherType.WIFICIPHER_WEP;
            } else {
                Log.e("wifidemo", "no");
                return WifiCipherType.WIFICIPHER_NOPASS;
            }
        }

        return WifiCipherType.WIFICIPHER_INVALID;
    }

    /**  扫描WIFI AP  */
    public boolean startStan() {
        if (mWifiManager == null) {
            return false;
        }
        return mWifiManager.startScan();
    }

    // 打开wifi功能
    public boolean openWifi() {
        boolean bRet = true;
        if (!mWifiManager.isWifiEnabled()) {
            bRet = mWifiManager.setWifiEnabled(true);
        }
        return bRet;
    }

    // 关闭WIFI
    public void closeWifi() {
        if (mWifiManager.isWifiEnabled()) {
            mWifiManager.setWifiEnabled(false);
        }
    }
}
