package cn.com.broadlink.tool.libs.common;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

/**
 * <pre>
 * URL工具类
 * @author YeJing
 * @data 2018/6/21
 * </pre>
 */

public final class BLUrlUtils {

	private BLUrlUtils(){}

	/**
	 * 获取Url的协议
	 * @param urlString
	 * @return
	 */
	public static String urlProtocol(String urlString){
		String host = null;
		try {
			URL url = new URL(urlString);
			host = url.getProtocol();
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		return host;
	}

	/**
	 * 获取Url的域名
	 * @param urlSrt  Url地址
	 * @return String host 域名
	 */
	public static String host(String urlSrt) {
		String host = null;
		try {
			URL url = new URL(urlSrt);
			host = url.getHost();
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		return host;
	}

	/**
	 * 域名转Ip地址
	 * @param host  域名
	 * @return ip地址
	 */
	public static String hostInetAddress(String host) {
		String IPAddress = null;
		InetAddress ReturnStr1 = null;
		try {
			ReturnStr1 = java.net.InetAddress.getByName(host);
			IPAddress = ReturnStr1.getHostAddress();
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}
		return IPAddress;
	}
}
