package cn.com.broadlink.tool.libs.common;

import android.util.Log;

/**
 * 项目名称：BLEControlAppV4    
 * 类名称：BLLogUtils
 * 类描述：  易控Log信息打印
 * 创建人：YeJing 
 * 创建时间：2015-3-24 下午4:26:57    
 * 修改人：Administrator    
 * 修改时间：2015-3-24 下午4:26:57    
 * 修改备注：    
 * @version     
 *
 */
public final class BLLogUtils {
    private final static String TAG = "BLLogUtils";
    
    /***是否打印Log Debug信息***/
    private static boolean DEBUG = true;
    
    /***是否打印 Info信息***/
    private static boolean INFO  = true;
    
    /***是否打印Log error信息***/
    private static boolean ERROR = true;
    
    /***是否打印Log warn信息***/
    private static boolean WARN  = true;

    public static void d(String msg){
        d(TAG, msg);
    }

    public static void d(String tag, String msg){
        if(DEBUG) {
			Log.d(tag, msg);}
    }

    public static void i(String msg){
        i(TAG, msg);
    }

    public static void i(String tag, String msg){
        if(INFO) {
			Log.i(tag, msg);}
    }

    public static void e(String msg){
        e(TAG, msg);
    }

    public static void e(String tag, String msg){
        if(ERROR) {
			Log.e(tag, msg);}
    }
    
    public static void e(String tag, String msg, Throwable tr){
        if(ERROR) {
			Log.e(tag, msg, tr);}
    }

    public static void w(String msg){
        w(TAG, msg);
    }
    public static void w(String tag, String msg){
        if(WARN) {
			Log.w(tag, msg);}
    }
    
}
