//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.response;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderResponse;
import cn.com.antcloud.api.provider.csc.v1_0.model.OnlineAgentMetric;
import java.lang.Long;
import java.util.List;

/**
 * 在线坐席监控指标 */
public class QueryMonitorOnlineAgentResponse extends AntCloudProdProviderResponse<QueryMonitorOnlineAgentResponse> {
  private List<OnlineAgentMetric> agentMetrics;

  private Long pageNum;

  private Long pageSize;

  private Long totalCount;

  /**
   * 在线坐席监控指标 */
  public List<OnlineAgentMetric> getAgentMetrics() {
    return this.agentMetrics;
  }

  /**
   * 在线坐席监控指标 */
  public void setAgentMetrics(List<OnlineAgentMetric> agentMetrics) {
    this.agentMetrics = agentMetrics;
  }

  /**
   * 查询结果的页码，起始值为 1 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 查询结果的页码，起始值为 1 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 当前页返回的条数 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 当前页返回的条数 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 总条目数 */
  public Long getTotalCount() {
    return this.totalCount;
  }

  /**
   * 总条目数 */
  public void setTotalCount(Long totalCount) {
    this.totalCount = totalCount;
  }
}
