//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.response;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 工作台服务记录查询接口，无条件时按照创建时间由大到小默认排序分页返回
 */
public class QueryFccsplatformServicerecordResponse extends AntCloudProdProviderResponse<QueryFccsplatformServicerecordResponse> {
  @NotNull
  private String data;

  @NotNull
  private String limit;

  @NotNull
  private String pagenum;

  @NotNull
  private String pagesize;

  @NotNull
  private String start;

  @NotNull
  private String total;

  @NotNull
  private String totalpages;

  /**
   * 对应服务记录数据 */
  public String getData() {
    return this.data;
  }

  /**
   * 对应服务记录数据 */
  public void setData(String data) {
    this.data = data;
  }

  /**
   * 查询记录数量 */
  public String getLimit() {
    return this.limit;
  }

  /**
   * 查询记录数量 */
  public void setLimit(String limit) {
    this.limit = limit;
  }

  /**
   * 当前页码 */
  public String getPagenum() {
    return this.pagenum;
  }

  /**
   * 当前页码 */
  public void setPagenum(String pagenum) {
    this.pagenum = pagenum;
  }

  /**
   * 当前页记录数 */
  public String getPagesize() {
    return this.pagesize;
  }

  /**
   * 当前页记录数 */
  public void setPagesize(String pagesize) {
    this.pagesize = pagesize;
  }

  /**
   * 查询记录开始行数 */
  public String getStart() {
    return this.start;
  }

  /**
   * 查询记录开始行数 */
  public void setStart(String start) {
    this.start = start;
  }

  /**
   * 记录总数 */
  public String getTotal() {
    return this.total;
  }

  /**
   * 记录总数 */
  public void setTotal(String total) {
    this.total = total;
  }

  /**
   * 总页数 */
  public String getTotalpages() {
    return this.totalpages;
  }

  /**
   * 总页数 */
  public void setTotalpages(String totalpages) {
    this.totalpages = totalpages;
  }
}
