//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.response;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderResponse;
import cn.com.antcloud.api.provider.csc.v1_0.model.RobotSessionDetail;
import java.lang.String;
import java.util.List;

/**
 * 查询最近一个未结束的机器人会话
 */
public class LastRobotSessionResponse extends AntCloudProdProviderResponse<LastRobotSessionResponse> {
  private List<RobotSessionDetail> sessionDetails;

  private String sessionId;

  private String startTime;

  /**
   * 会话的问答详情模型列表 */
  public List<RobotSessionDetail> getSessionDetails() {
    return this.sessionDetails;
  }

  /**
   * 会话的问答详情模型列表 */
  public void setSessionDetails(List<RobotSessionDetail> sessionDetails) {
    this.sessionDetails = sessionDetails;
  }

  /**
   * 机器人会话ID */
  public String getSessionId() {
    return this.sessionId;
  }

  /**
   * 机器人会话ID */
  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }

  /**
   * 会话开始时间，按照ISO8601标准表示 */
  public String getStartTime() {
    return this.startTime;
  }

  /**
   * 会话开始时间，按照ISO8601标准表示 */
  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }
}
