//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.response;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 根据工单id查询工单
 */
public class GetProcessTicketResponse extends AntCloudProdProviderResponse<GetProcessTicketResponse> {
  @NotNull
  private String ccsInstanceId;

  @NotNull
  private String createTime;

  @NotNull
  private String creatorId;

  @NotNull
  private String customFields;

  @NotNull
  private String description;

  private String finishTime;

  @NotNull
  private String id;

  @NotNull
  private String node;

  private String operatorId;

  private String shouldFinishTime;

  @NotNull
  private String type;

  /**
   * 数据权限id(租户实例id)：ZPASFSCN */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(租户实例id)：ZPASFSCN */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 工单创建时间，按照ISO8601标准表示 */
  public String getCreateTime() {
    return this.createTime;
  }

  /**
   * 工单创建时间，按照ISO8601标准表示 */
  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  /**
   * 工单创建者的用户id */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 工单创建者的用户id */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 工单类型对应的自定义表单json数据 */
  public String getCustomFields() {
    return this.customFields;
  }

  /**
   * 工单类型对应的自定义表单json数据 */
  public void setCustomFields(String customFields) {
    this.customFields = customFields;
  }

  /**
   * 工单描述，即创建工单时填写的描述信息 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 工单描述，即创建工单时填写的描述信息 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 工单完结时间，按照ISO8601标准表示 */
  public String getFinishTime() {
    return this.finishTime;
  }

  /**
   * 工单完结时间，按照ISO8601标准表示 */
  public void setFinishTime(String finishTime) {
    this.finishTime = finishTime;
  }

  /**
   * 工单id */
  public String getId() {
    return this.id;
  }

  /**
   * 工单id */
  public void setId(String id) {
    this.id = id;
  }

  /**
   * 工单当前所在的处理节点，例如：一级处理、撤销、完成等。 */
  public String getNode() {
    return this.node;
  }

  /**
   * 工单当前所在的处理节点，例如：一级处理、撤销、完成等。 */
  public void setNode(String node) {
    this.node = node;
  }

  /**
   * 当前工单的操作人id */
  public String getOperatorId() {
    return this.operatorId;
  }

  /**
   * 当前工单的操作人id */
  public void setOperatorId(String operatorId) {
    this.operatorId = operatorId;
  }

  /**
   * 工单应该完成的时间(超时截止时间)，按照ISO8601标准表示 */
  public String getShouldFinishTime() {
    return this.shouldFinishTime;
  }

  /**
   * 工单应该完成的时间(超时截止时间)，按照ISO8601标准表示 */
  public void setShouldFinishTime(String shouldFinishTime) {
    this.shouldFinishTime = shouldFinishTime;
  }

  /**
   * 工单类型 */
  public String getType() {
    return this.type;
  }

  /**
   * 工单类型 */
  public void setType(String type) {
    this.type = type;
  }
}
