//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.response;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderResponse;
import cn.com.antcloud.api.provider.csc.v1_0.model.RuleMatchDetail;
import cn.com.antcloud.api.provider.csc.v1_0.model.SentenceDetail;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 查询质检结果
 */
public class GetInspectResultResponse extends AntCloudProdProviderResponse<GetInspectResultResponse> {
  private String message;

  private List<RuleMatchDetail> ruleMatchDetails;

  private Long score;

  private List<SentenceDetail> sentences;

  @NotNull
  private String status;

  @NotNull
  private String type;

  /**
   * 提示信息 */
  public String getMessage() {
    return this.message;
  }

  /**
   * 提示信息 */
  public void setMessage(String message) {
    this.message = message;
  }

  /**
   * RuleMatchDetail对象数组，质检规格匹配详情 */
  public List<RuleMatchDetail> getRuleMatchDetails() {
    return this.ruleMatchDetails;
  }

  /**
   * RuleMatchDetail对象数组，质检规格匹配详情 */
  public void setRuleMatchDetails(List<RuleMatchDetail> ruleMatchDetails) {
    this.ruleMatchDetails = ruleMatchDetails;
  }

  /**
   * 质检最终的分值 */
  public Long getScore() {
    return this.score;
  }

  /**
   * 质检最终的分值 */
  public void setScore(Long score) {
    this.score = score;
  }

  /**
   * SentenceDetail对象数组，包含了对话中的每一句话 */
  public List<SentenceDetail> getSentences() {
    return this.sentences;
  }

  /**
   * SentenceDetail对象数组，包含了对话中的每一句话 */
  public void setSentences(List<SentenceDetail> sentences) {
    this.sentences = sentences;
  }

  /**
   * 质检任务执行的状态 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 质检任务执行的状态 */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 任务类型 */
  public String getType() {
    return this.type;
  }

  /**
   * 任务类型 */
  public void setType(String type) {
    this.type = type;
  }
}
