//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.response;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderResponse;
import java.lang.String;

/**
 * 查询发送钉钉服务群消息的结果。发送钉钉服务群消息的过程是异步的，所以需要在发送后通过消息id来查询发送结果。消息发送结果最多保存7天 */
public class GetDingtalkMessageResultResponse extends AntCloudProdProviderResponse<GetDingtalkMessageResultResponse> {
  private String status;

  /**
   * 消息发送的状态。
   * SUCCEEDED：发送完成;
   * PROCESSING：发送中;
   * FAILED：发送失败; */
  public String getStatus() {
    return this.status;
  }

  /**
   * 消息发送的状态。
   * SUCCEEDED：发送完成;
   * PROCESSING：发送中;
   * FAILED：发送失败; */
  public void setStatus(String status) {
    this.status = status;
  }
}
