//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.response;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderResponse;
import cn.com.antcloud.api.provider.csc.v1_0.model.AgentChatModel;
import cn.com.antcloud.api.provider.csc.v1_0.model.AgentHotlineModel;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 查询一个客服
 */
public class GetBuserviceAgentResponse extends AntCloudProdProviderResponse<GetBuserviceAgentResponse> {
  private String answeringMode;

  private String avatar;

  @NotNull
  private List<String> ccsInstanceIds;

  private List<AgentChatModel> chatConfig;

  @NotNull
  private String createTime;

  @NotNull
  private String creatorId;

  private String dingtalkUserId;

  private String email;

  @NotNull
  private String externalId;

  private List<AgentHotlineModel> hotlineConfig;

  @NotNull
  private String id;

  @NotNull
  private String jobNumber;

  private String lastLoginTime;

  @NotNull
  private String loginName;

  private String mobile;

  @NotNull
  private String nickName;

  private String profile;

  @NotNull
  private String realName;

  @NotNull
  private List<String> roleIds;

  @NotNull
  private String status;

  @NotNull
  private String type;

  @NotNull
  private String updaterId;

  @NotNull
  private String updateTime;

  /**
   * 热线接入方式 0：话机 1：电脑耳机 2：webrtc */
  public String getAnsweringMode() {
    return this.answeringMode;
  }

  /**
   * 热线接入方式 0：话机 1：电脑耳机 2：webrtc */
  public void setAnsweringMode(String answeringMode) {
    this.answeringMode = answeringMode;
  }

  /**
   * 头像的oss file key： */
  public String getAvatar() {
    return this.avatar;
  }

  /**
   * 头像的oss file key： */
  public void setAvatar(String avatar) {
    this.avatar = avatar;
  }

  /**
   * 客服关联的数据权限id列表：["ZPASFSCN","QWT_SADLD"] */
  public List<String> getCcsInstanceIds() {
    return this.ccsInstanceIds;
  }

  /**
   * 客服关联的数据权限id列表：["ZPASFSCN","QWT_SADLD"] */
  public void setCcsInstanceIds(List<String> ccsInstanceIds) {
    this.ccsInstanceIds = ccsInstanceIds;
  }

  /**
   * 在线技能组配置 */
  public List<AgentChatModel> getChatConfig() {
    return this.chatConfig;
  }

  /**
   * 在线技能组配置 */
  public void setChatConfig(List<AgentChatModel> chatConfig) {
    this.chatConfig = chatConfig;
  }

  /**
   * 创建时间，按照ISO8601标准表示 */
  public String getCreateTime() {
    return this.createTime;
  }

  /**
   * 创建时间，按照ISO8601标准表示 */
  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  /**
   * 创建人id */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 创建人id */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 钉钉user_id（来自钉钉的租户该字段非空）：1293894912 */
  public String getDingtalkUserId() {
    return this.dingtalkUserId;
  }

  /**
   * 钉钉user_id（来自钉钉的租户该字段非空）：1293894912 */
  public void setDingtalkUserId(String dingtalkUserId) {
    this.dingtalkUserId = dingtalkUserId;
  }

  /**
   * 邮箱：abc@alipay.com */
  public String getEmail() {
    return this.email;
  }

  /**
   * 邮箱：abc@alipay.com */
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * 外部系统用户id：112133。比如：金融云的用户id */
  public String getExternalId() {
    return this.externalId;
  }

  /**
   * 外部系统用户id：112133。比如：金融云的用户id */
  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  /**
   * 热线技能组配置 */
  public List<AgentHotlineModel> getHotlineConfig() {
    return this.hotlineConfig;
  }

  /**
   * 热线技能组配置 */
  public void setHotlineConfig(List<AgentHotlineModel> hotlineConfig) {
    this.hotlineConfig = hotlineConfig;
  }

  /**
   * 客服唯一标识id：246534573 */
  public String getId() {
    return this.id;
  }

  /**
   * 客服唯一标识id：246534573 */
  public void setId(String id) {
    this.id = id;
  }

  /**
   * 工号：0001 */
  public String getJobNumber() {
    return this.jobNumber;
  }

  /**
   * 工号：0001 */
  public void setJobNumber(String jobNumber) {
    this.jobNumber = jobNumber;
  }

  /**
   * 最后登录时间，按照ISO8601标准表示 */
  public String getLastLoginTime() {
    return this.lastLoginTime;
  }

  /**
   * 最后登录时间，按照ISO8601标准表示 */
  public void setLastLoginTime(String lastLoginTime) {
    this.lastLoginTime = lastLoginTime;
  }

  /**
   * 客服登录账户：abc@alipay.com */
  public String getLoginName() {
    return this.loginName;
  }

  /**
   * 客服登录账户：abc@alipay.com */
  public void setLoginName(String loginName) {
    this.loginName = loginName;
  }

  /**
   * 手机号：17712341234 */
  public String getMobile() {
    return this.mobile;
  }

  /**
   * 手机号：17712341234 */
  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  /**
   * 昵称：风清扬 */
  public String getNickName() {
    return this.nickName;
  }

  /**
   * 昵称：风清扬 */
  public void setNickName(String nickName) {
    this.nickName = nickName;
  }

  /**
   * 个人简介：我是玉树临风一表人才的张三 */
  public String getProfile() {
    return this.profile;
  }

  /**
   * 个人简介：我是玉树临风一表人才的张三 */
  public void setProfile(String profile) {
    this.profile = profile;
  }

  /**
   * 姓名：张三 */
  public String getRealName() {
    return this.realName;
  }

  /**
   * 姓名：张三 */
  public void setRealName(String realName) {
    this.realName = realName;
  }

  /**
   * 角色id列表：["11","22"] */
  public List<String> getRoleIds() {
    return this.roleIds;
  }

  /**
   * 角色id列表：["11","22"] */
  public void setRoleIds(List<String> roleIds) {
    this.roleIds = roleIds;
  }

  /**
   * 状态：NORMAL，DELETE */
  public String getStatus() {
    return this.status;
  }

  /**
   * 状态：NORMAL，DELETE */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 用户类型：NORMAL（普通客服），ADMIN（超级管理员，不能被删除） */
  public String getType() {
    return this.type;
  }

  /**
   * 用户类型：NORMAL（普通客服），ADMIN（超级管理员，不能被删除） */
  public void setType(String type) {
    this.type = type;
  }

  /**
   * 最后修改人id */
  public String getUpdaterId() {
    return this.updaterId;
  }

  /**
   * 最后修改人id */
  public void setUpdaterId(String updaterId) {
    this.updaterId = updaterId;
  }

  /**
   * 最后修改时间，按照ISO8601标准表示 */
  public String getUpdateTime() {
    return this.updateTime;
  }

  /**
   * 最后修改时间，按照ISO8601标准表示 */
  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }
}
