//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.response;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderResponse;
import cn.com.antcloud.api.provider.csc.v1_0.model.Credentials;
import cn.com.antcloud.api.provider.csc.v1_0.model.StorageAccessPolicy;
import javax.validation.constraints.NotNull;

/**
 * 获取访问存储的身份和访问策略，比如：获取访问oss的STS token身份和目标oss bucket信息
 */
public class AccessCsmngStorageResponse extends AntCloudProdProviderResponse<AccessCsmngStorageResponse> {
  @NotNull
  private Credentials credentials;

  @NotNull
  private StorageAccessPolicy policy;

  /**
   * 存储操作的身份信息 */
  public Credentials getCredentials() {
    return this.credentials;
  }

  /**
   * 存储操作的身份信息 */
  public void setCredentials(Credentials credentials) {
    this.credentials = credentials;
  }

  /**
   * 存储策略信息，比如：可操作的bucekt名称，可操作的OSS prefix */
  public StorageAccessPolicy getPolicy() {
    return this.policy;
  }

  /**
   * 存储策略信息，比如：可操作的bucekt名称，可操作的OSS prefix */
  public void setPolicy(StorageAccessPolicy policy) {
    this.policy = policy;
  }
}
