//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.model.Attachment;
import cn.com.antcloud.api.provider.csc.v1_0.response.UpdateProcessTicketResponse;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 工单更新，增量字段
 */
public class UpdateProcessTicketRequest extends AntCloudProdProviderRequest<UpdateProcessTicketResponse> {
  private List<Attachment> attachments;

  private String ccsInstanceId;

  @NotNull
  private String customFields;

  @NotNull
  private String id;

  private String memo;

  private String operatorId;

  /**
   * 多个备注附件的oss  key（文件和图片）,最多10个附件 */
  public List<Attachment> getAttachments() {
    return this.attachments;
  }

  /**
   * 多个备注附件的oss  key（文件和图片）,最多10个附件 */
  public void setAttachments(List<Attachment> attachments) {
    this.attachments = attachments;
  }

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 工单的自定义表单内容，支持字符串、地域、文件。支持增量更新，即更新部分字段。
   *                              */
  public String getCustomFields() {
    return this.customFields;
  }

  /**
   * 工单的自定义表单内容，支持字符串、地域、文件。支持增量更新，即更新部分字段。
   *                              */
  public void setCustomFields(String customFields) {
    this.customFields = customFields;
  }

  /**
   * 工单id */
  public String getId() {
    return this.id;
  }

  /**
   * 工单id */
  public void setId(String id) {
    this.id = id;
  }

  /**
   * 备注信息 */
  public String getMemo() {
    return this.memo;
  }

  /**
   * 备注信息 */
  public void setMemo(String memo) {
    this.memo = memo;
  }

  /**
   * 修改者的用户id，如果为空，则默认为系统 */
  public String getOperatorId() {
    return this.operatorId;
  }

  /**
   * 修改者的用户id，如果为空，则默认为系统 */
  public void setOperatorId(String operatorId) {
    this.operatorId = operatorId;
  }
}
