//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.model.AgentChatModel;
import cn.com.antcloud.api.provider.csc.v1_0.model.AgentHotlineModel;
import cn.com.antcloud.api.provider.csc.v1_0.response.UpdateBuserviceAgentResponse;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 更新客服人员
 */
public class UpdateBuserviceAgentRequest extends AntCloudProdProviderRequest<UpdateBuserviceAgentResponse> {
  private String answeringMode;

  private String avatar;

  @NotNull
  private String ccsInstanceIds;

  private List<AgentChatModel> chatConfig;

  private String email;

  private List<AgentHotlineModel> hotlineConfig;

  @NotNull
  private String id;

  private String mobile;

  @NotNull
  private String nickName;

  private String profile;

  @NotNull
  private String realName;

  @NotNull
  private String roleIds;

  @NotNull
  private String updaterId;

  /**
   * 热线接入方式 */
  public String getAnsweringMode() {
    return this.answeringMode;
  }

  /**
   * 热线接入方式 */
  public void setAnsweringMode(String answeringMode) {
    this.answeringMode = answeringMode;
  }

  /**
   * 头像的oss file key */
  public String getAvatar() {
    return this.avatar;
  }

  /**
   * 头像的oss file key */
  public void setAvatar(String avatar) {
    this.avatar = avatar;
  }

  /**
   * 客服关联的数据权限id的json数组 */
  public String getCcsInstanceIds() {
    return this.ccsInstanceIds;
  }

  /**
   * 客服关联的数据权限id的json数组 */
  public void setCcsInstanceIds(String ccsInstanceIds) {
    this.ccsInstanceIds = ccsInstanceIds;
  }

  /**
   * 在线技能组配置 */
  public List<AgentChatModel> getChatConfig() {
    return this.chatConfig;
  }

  /**
   * 在线技能组配置 */
  public void setChatConfig(List<AgentChatModel> chatConfig) {
    this.chatConfig = chatConfig;
  }

  /**
   * 邮箱 */
  public String getEmail() {
    return this.email;
  }

  /**
   * 邮箱 */
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * 热线技能组配置 */
  public List<AgentHotlineModel> getHotlineConfig() {
    return this.hotlineConfig;
  }

  /**
   * 热线技能组配置 */
  public void setHotlineConfig(List<AgentHotlineModel> hotlineConfig) {
    this.hotlineConfig = hotlineConfig;
  }

  /**
   * 客服ID */
  public String getId() {
    return this.id;
  }

  /**
   * 客服ID */
  public void setId(String id) {
    this.id = id;
  }

  /**
   * 手机号 */
  public String getMobile() {
    return this.mobile;
  }

  /**
   * 手机号 */
  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  /**
   * 昵称 */
  public String getNickName() {
    return this.nickName;
  }

  /**
   * 昵称 */
  public void setNickName(String nickName) {
    this.nickName = nickName;
  }

  /**
   * 个人简介 */
  public String getProfile() {
    return this.profile;
  }

  /**
   * 个人简介 */
  public void setProfile(String profile) {
    this.profile = profile;
  }

  /**
   * 姓名 */
  public String getRealName() {
    return this.realName;
  }

  /**
   * 姓名 */
  public void setRealName(String realName) {
    this.realName = realName;
  }

  /**
   * 角色id的json数组 */
  public String getRoleIds() {
    return this.roleIds;
  }

  /**
   * 角色id的json数组 */
  public void setRoleIds(String roleIds) {
    this.roleIds = roleIds;
  }

  /**
   * 最后更新人id */
  public String getUpdaterId() {
    return this.updaterId;
  }

  /**
   * 最后更新人id */
  public void setUpdaterId(String updaterId) {
    this.updaterId = updaterId;
  }
}
