//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.SetProcessTicketFlagResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 设置工单的标记，比如：已读、未读 */
public class SetProcessTicketFlagRequest extends AntCloudProdProviderRequest<SetProcessTicketFlagResponse> {
  private String ccsInstanceId;

  @NotNull
  private String flag;

  @NotNull
  private String id;

  private String operatorId;

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 工单的标记，比如：READ、UNREAD */
  public String getFlag() {
    return this.flag;
  }

  /**
   * 工单的标记，比如：READ、UNREAD */
  public void setFlag(String flag) {
    this.flag = flag;
  }

  /**
   * 工单id */
  public String getId() {
    return this.id;
  }

  /**
   * 工单id */
  public void setId(String id) {
    this.id = id;
  }

  /**
   * 操作人的用户id */
  public String getOperatorId() {
    return this.operatorId;
  }

  /**
   * 操作人的用户id */
  public void setOperatorId(String operatorId) {
    this.operatorId = operatorId;
  }
}
