//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.SendDingtalkMessageResponse;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 发送钉钉服务群消息，支持markdown。 */
public class SendDingtalkMessageRequest extends AntCloudProdProviderRequest<SendDingtalkMessageResponse> {
  private Boolean atAll;

  private List<String> atDingTalkIds;

  private List<String> atMobiles;

  @NotNull
  private String chatId;

  @NotNull
  private String messageContent;

  @NotNull
  private String messageType;

  private List<String> receiverDingTalkIds;

  /**
   * 是否at钉钉服务群中的所有人，默认为false。
   * 当at_all为true时，at_ding_talk_ids和at_mobiles必须为空；
   * 当at_ding_talk_ids有值时，at_all必须为false，at_mobiles必须为空；
   * 当at_mobiles有值时，at_all必须为false，at_ding_talk_ids必须为空； */
  public Boolean getAtAll() {
    return this.atAll;
  }

  /**
   * 是否at钉钉服务群中的所有人，默认为false。
   * 当at_all为true时，at_ding_talk_ids和at_mobiles必须为空；
   * 当at_ding_talk_ids有值时，at_all必须为false，at_mobiles必须为空；
   * 当at_mobiles有值时，at_all必须为false，at_ding_talk_ids必须为空； */
  public void setAtAll(Boolean atAll) {
    this.atAll = atAll;
  }

  /**
   * 用户在钉钉的全局唯一dingTalkId。
   * 当at_all为true时，at_ding_talk_ids和at_mobiles必须为空；
   * 当at_ding_talk_ids有值时，at_all必须为false，at_mobiles必须为空；
   * 当at_mobiles有值时，at_all必须为false，at_ding_talk_ids必须为空； */
  public List<String> getAtDingTalkIds() {
    return this.atDingTalkIds;
  }

  /**
   * 用户在钉钉的全局唯一dingTalkId。
   * 当at_all为true时，at_ding_talk_ids和at_mobiles必须为空；
   * 当at_ding_talk_ids有值时，at_all必须为false，at_mobiles必须为空；
   * 当at_mobiles有值时，at_all必须为false，at_ding_talk_ids必须为空； */
  public void setAtDingTalkIds(List<String> atDingTalkIds) {
    this.atDingTalkIds = atDingTalkIds;
  }

  /**
   * 被at钉钉用户的手机号。
   * 当at_all为true时，at_ding_talk_ids和at_mobiles必须为空；
   * 当at_ding_talk_ids有值时，at_all必须为false，at_mobiles必须为空；
   * 当at_mobiles有值时，at_all必须为false，at_ding_talk_ids必须为空； */
  public List<String> getAtMobiles() {
    return this.atMobiles;
  }

  /**
   * 被at钉钉用户的手机号。
   * 当at_all为true时，at_ding_talk_ids和at_mobiles必须为空；
   * 当at_ding_talk_ids有值时，at_all必须为false，at_mobiles必须为空；
   * 当at_mobiles有值时，at_all必须为false，at_ding_talk_ids必须为空； */
  public void setAtMobiles(List<String> atMobiles) {
    this.atMobiles = atMobiles;
  }

  /**
   * 钉钉服务群会话id */
  public String getChatId() {
    return this.chatId;
  }

  /**
   * 钉钉服务群会话id */
  public void setChatId(String chatId) {
    this.chatId = chatId;
  }

  /**
   * 消息内容。
   * message_type=IMAGE时，
   * message_content类似这样：{"type":"TICKET_ATTACHMENT","fileKey":"2018040319/TICEKT_ATTACHMENT/TEST0314/TEST0314/hello.jpg"}。
   * type：调用ccs.csmng.storage.access时传的参数;
   * file_key：调用ccs.csmng.storage.submit时返回的file_key;
   *
   * message_type=MARKDOWN时，
   * message_content类似这样：{"title":"首屏会话透出的展示内容","text":"# 这是支持markdown的文本 \n## 标题2  \n* 列表1 \n![alt 啊](https://gw.alipayobjects.com/zos/skylark-tools/public/files/b424a1af2f0766f39d4a7df52ebe0083.png)"} */
  public String getMessageContent() {
    return this.messageContent;
  }

  /**
   * 消息内容。
   * message_type=IMAGE时，
   * message_content类似这样：{"type":"TICKET_ATTACHMENT","fileKey":"2018040319/TICEKT_ATTACHMENT/TEST0314/TEST0314/hello.jpg"}。
   * type：调用ccs.csmng.storage.access时传的参数;
   * file_key：调用ccs.csmng.storage.submit时返回的file_key;
   *
   * message_type=MARKDOWN时，
   * message_content类似这样：{"title":"首屏会话透出的展示内容","text":"# 这是支持markdown的文本 \n## 标题2  \n* 列表1 \n![alt 啊](https://gw.alipayobjects.com/zos/skylark-tools/public/files/b424a1af2f0766f39d4a7df52ebe0083.png)"} */
  public void setMessageContent(String messageContent) {
    this.messageContent = messageContent;
  }

  /**
   * 消息类型。值有如下两个：
   * IMAGE：图片；
   * MARKDOWN：markdown格式的消息，如果图片url的公网可以访问，也可以以markdown格式发图片。
   * ACTION_CARD：类似钉钉卡片消息(https://open-doc.dingtalk.com/microapp/serverapi3/xxxza0#-23) */
  public String getMessageType() {
    return this.messageType;
  }

  /**
   * 消息类型。值有如下两个：
   * IMAGE：图片；
   * MARKDOWN：markdown格式的消息，如果图片url的公网可以访问，也可以以markdown格式发图片。
   * ACTION_CARD：类似钉钉卡片消息(https://open-doc.dingtalk.com/microapp/serverapi3/xxxza0#-23) */
  public void setMessageType(String messageType) {
    this.messageType = messageType;
  }

  /**
   * 接收此消息的群成员ID列表 */
  public List<String> getReceiverDingTalkIds() {
    return this.receiverDingTalkIds;
  }

  /**
   * 接收此消息的群成员ID列表 */
  public void setReceiverDingTalkIds(List<String> receiverDingTalkIds) {
    this.receiverDingTalkIds = receiverDingTalkIds;
  }
}
