//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.QueryRobotSessionResponse;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 查询机器人会话
 */
public class QueryRobotSessionRequest extends AntCloudProdProviderRequest<QueryRobotSessionResponse> {
  private String answerSource;

  private String endTime;

  @NotNull
  private Long pageNum;

  @NotNull
  private Long pageSize;

  private String sceneId;

  private String startTime;

  private String utterance;

  private String vote;

  /**
   * 答案来源 */
  public String getAnswerSource() {
    return this.answerSource;
  }

  /**
   * 答案来源 */
  public void setAnswerSource(String answerSource) {
    this.answerSource = answerSource;
  }

  /**
   * 查询时间范围的末尾时间，按照ISO8601标准表示 */
  public String getEndTime() {
    return this.endTime;
  }

  /**
   * 查询时间范围的末尾时间，按照ISO8601标准表示 */
  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  /**
   * 查询结果的页码，起始值为 1，默认值为 1 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 查询结果的页码，起始值为 1，默认值为 1 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 分页查询时设置的每页记录数，最大值 100 行，默认为 10 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 分页查询时设置的每页记录数，最大值 100 行，默认为 10 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 场景ID */
  public String getSceneId() {
    return this.sceneId;
  }

  /**
   * 场景ID */
  public void setSceneId(String sceneId) {
    this.sceneId = sceneId;
  }

  /**
   * 查询时间范围的起始时间，按照ISO8601标准表示 */
  public String getStartTime() {
    return this.startTime;
  }

  /**
   * 查询时间范围的起始时间，按照ISO8601标准表示 */
  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  /**
   * 提问内容 */
  public String getUtterance() {
    return this.utterance;
  }

  /**
   * 提问内容 */
  public void setUtterance(String utterance) {
    this.utterance = utterance;
  }

  /**
   * 机器评价的投票值 */
  public String getVote() {
    return this.vote;
  }

  /**
   * 机器评价的投票值 */
  public void setVote(String vote) {
    this.vote = vote;
  }
}
