//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.QueryProcessTicketResponse;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 工单查询
 */
public class QueryProcessTicketRequest extends AntCloudProdProviderRequest<QueryProcessTicketResponse> {
  private String ccsInstanceId;

  private String creatorId;

  private String description;

  private String endTime;

  private String node;

  private String operatorId;

  @NotNull
  private Long pageNum;

  @NotNull
  private Long pageSize;

  private String startTime;

  private String timeout;

  private String type;

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 创建者的用户id */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 创建者的用户id */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 工单描述信息，支持模糊匹配 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 工单描述信息，支持模糊匹配 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 会话开始时间，按照ISO8601标准表示 */
  public String getEndTime() {
    return this.endTime;
  }

  /**
   * 会话开始时间，按照ISO8601标准表示 */
  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  /**
   * 工单处理所在节点，例如：创建、一级处理、二级处理、三级处理、重新提交、加签、撤销、完成等。 */
  public String getNode() {
    return this.node;
  }

  /**
   * 工单处理所在节点，例如：创建、一级处理、二级处理、三级处理、重新提交、加签、撤销、完成等。 */
  public void setNode(String node) {
    this.node = node;
  }

  /**
   * 当前工单处理人id，如果工单已完结，则该字段为空 */
  public String getOperatorId() {
    return this.operatorId;
  }

  /**
   * 当前工单处理人id，如果工单已完结，则该字段为空 */
  public void setOperatorId(String operatorId) {
    this.operatorId = operatorId;
  }

  /**
   * 查询结果的页码，起始值为 1，默认值为 1 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 查询结果的页码，起始值为 1，默认值为 1 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 分页查询时设置的每页记录数，最大值 100 行，默认为 10 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 分页查询时设置的每页记录数，最大值 100 行，默认为 10 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 会话开始时间，按照ISO8601标准表示 */
  public String getStartTime() {
    return this.startTime;
  }

  /**
   * 会话开始时间，按照ISO8601标准表示 */
  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  /**
   * 工单处理所在节点，例如：创建、一级处理、二级处理、三级处理、重新提交、加签、撤销、完成等。 */
  public String getTimeout() {
    return this.timeout;
  }

  /**
   * 工单处理所在节点，例如：创建、一级处理、二级处理、三级处理、重新提交、加签、撤销、完成等。 */
  public void setTimeout(String timeout) {
    this.timeout = timeout;
  }

  /**
   * 工单类型 */
  public String getType() {
    return this.type;
  }

  /**
   * 工单类型 */
  public void setType(String type) {
    this.type = type;
  }
}
