//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.QueryMonitorOnlineAgentResponse;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 在线坐席监控指标 */
public class QueryMonitorOnlineAgentRequest extends AntCloudProdProviderRequest<QueryMonitorOnlineAgentResponse> {
  private String ccsInstanceId;

  @NotNull
  private String groupId;

  private List<String> metricNames;

  @NotNull
  @Min(1)
  private Long pageNum;

  @NotNull
  @Min(1)
  @Max(50)
  private Long pageSize;

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 查询在线坐席维度的监控指标 */
  public String getGroupId() {
    return this.groupId;
  }

  /**
   * 查询在线坐席维度的监控指标 */
  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  /**
   * 要返回的指标项，为空时返回所有指标项。
   * FIRST_ONLINE_TIME，坐席当日首次上线时间；
   * LAST_OFFLINE_TIME，坐席当日最后一次离线时间；
   * SERVICED_COUNT，坐席当日累计服务量；
   * SERVICING_COUNT，坐席当前正在进行中的服务量；
   * TRANSFERRED_COUNT，坐席当日累计转接量
   * VERY_GOOD_FEEDBACK_COUNT，当日累计，技能组中所有坐席收到的，非常满意服务评价量之和；
   * GOOD_FEEDBACK_COUNT，当日累计，技能组中所有坐席收到的，满意服务评价量之和；
   * GENERAL_FEEDBACK_COUNT，当日累计，技能组中所有坐席收到的，一般满意服务评价量之和；
   * BAD_FEEDBACK_COUNT，当日累计，技能组中所有坐席收到的，不满意服务评价量之和；
   * STATE，坐席当前状态，ONLINE、OFFLINE、ONGOING_OFFLINE */
  public List<String> getMetricNames() {
    return this.metricNames;
  }

  /**
   * 要返回的指标项，为空时返回所有指标项。
   * FIRST_ONLINE_TIME，坐席当日首次上线时间；
   * LAST_OFFLINE_TIME，坐席当日最后一次离线时间；
   * SERVICED_COUNT，坐席当日累计服务量；
   * SERVICING_COUNT，坐席当前正在进行中的服务量；
   * TRANSFERRED_COUNT，坐席当日累计转接量
   * VERY_GOOD_FEEDBACK_COUNT，当日累计，技能组中所有坐席收到的，非常满意服务评价量之和；
   * GOOD_FEEDBACK_COUNT，当日累计，技能组中所有坐席收到的，满意服务评价量之和；
   * GENERAL_FEEDBACK_COUNT，当日累计，技能组中所有坐席收到的，一般满意服务评价量之和；
   * BAD_FEEDBACK_COUNT，当日累计，技能组中所有坐席收到的，不满意服务评价量之和；
   * STATE，坐席当前状态，ONLINE、OFFLINE、ONGOING_OFFLINE */
  public void setMetricNames(List<String> metricNames) {
    this.metricNames = metricNames;
  }

  /**
   * 页码 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 页码 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 每页数量 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 每页数量 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }
}
