//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.QueryFccsplatformServicerecordResponse;
import java.lang.String;

/**
 * 工作台服务记录查询接口，无条件时按照创建时间由大到小默认排序分页返回
 */
public class QueryFccsplatformServicerecordRequest extends AntCloudProdProviderRequest<QueryFccsplatformServicerecordResponse> {
  private String beginTime;

  private String currentPage;

  private String endTime;

  private String id;

  private String pageSize;

  private String phone;

  private String serviceSource;

  private String status;

  private String userId;

  /**
   * 服务记录创建开始时间 */
  public String getBeginTime() {
    return this.beginTime;
  }

  /**
   * 服务记录创建开始时间 */
  public void setBeginTime(String beginTime) {
    this.beginTime = beginTime;
  }

  /**
   * 分页信息，缺省默认返回第一页数据 */
  public String getCurrentPage() {
    return this.currentPage;
  }

  /**
   * 分页信息，缺省默认返回第一页数据 */
  public void setCurrentPage(String currentPage) {
    this.currentPage = currentPage;
  }

  /**
   * 服务记录创建结束时间 */
  public String getEndTime() {
    return this.endTime;
  }

  /**
   * 服务记录创建结束时间 */
  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  /**
   * 服务记录ID，查询单条服务记录使用 */
  public String getId() {
    return this.id;
  }

  /**
   * 服务记录ID，查询单条服务记录使用 */
  public void setId(String id) {
    this.id = id;
  }

  /**
   * 页面大小，上限100条，缺省默认20条 */
  public String getPageSize() {
    return this.pageSize;
  }

  /**
   * 页面大小，上限100条，缺省默认20条 */
  public void setPageSize(String pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 客户与云客服平台交互的电话号码 */
  public String getPhone() {
    return this.phone;
  }

  /**
   * 客户与云客服平台交互的电话号码 */
  public void setPhone(String phone) {
    this.phone = phone;
  }

  /**
   * 服务来源，格式为Enum.id逗号间隔 */
  public String getServiceSource() {
    return this.serviceSource;
  }

  /**
   * 服务来源，格式为Enum.id逗号间隔 */
  public void setServiceSource(String serviceSource) {
    this.serviceSource = serviceSource;
  }

  /**
   * 服务记录状态条件，多条件时Enum.id逗号间隔 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 服务记录状态条件，多条件时Enum.id逗号间隔 */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 用户CRM的客户ID，当用户使用iframe或接口调用关联用户信息和服务记录时使用 */
  public String getUserId() {
    return this.userId;
  }

  /**
   * 用户CRM的客户ID，当用户使用iframe或接口调用关联用户信息和服务记录时使用 */
  public void setUserId(String userId) {
    this.userId = userId;
  }
}
