//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.QueryCsmngNoticeResponse;
import java.lang.Long;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 查询公告，可按照时间段，公告内容，创建人查询。 */
public class QueryCsmngNoticeRequest extends AntCloudProdProviderRequest<QueryCsmngNoticeResponse> {
  private String ccsInstanceId;

  private String content;

  private String creatorId;

  private Date endTime;

  @NotNull
  private Long pageNum;

  @NotNull
  private Long pageSize;

  private Date startTime;

  /**
   * 数据权限id(云客服租户实例id)，如果为空，则为默认数据权限 */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(云客服租户实例id)，如果为空，则为默认数据权限 */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 模糊匹配公共内容 */
  public String getContent() {
    return this.content;
  }

  /**
   * 模糊匹配公共内容 */
  public void setContent(String content) {
    this.content = content;
  }

  /**
   * 创建人（发布人）ID */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 创建人（发布人）ID */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 查询截止时间 */
  public Date getEndTime() {
    return this.endTime;
  }

  /**
   * 查询截止时间 */
  public void setEndTime(Date endTime) {
    this.endTime = endTime;
  }

  /**
   * 当前页码，从1开始，默认为1 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 当前页码，从1开始，默认为1 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 分页大小，取值范围[1~50],默认为10 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 分页大小，取值范围[1~50],默认为10 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 查询开始时间 */
  public Date getStartTime() {
    return this.startTime;
  }

  /**
   * 查询开始时间 */
  public void setStartTime(Date startTime) {
    this.startTime = startTime;
  }
}
