//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.QueryBuserviceAgentResponse;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 分页查询客服
 */
public class QueryBuserviceAgentRequest extends AntCloudProdProviderRequest<QueryBuserviceAgentResponse> {
  private String answeringMode;

  private String ccsInstanceId;

  private String chatExtendedGroupIds;

  private String chatGroupIds;

  private String chatLevelIds;

  private String email;

  private String hotlineGroupIds;

  @NotNull
  private Long pageNum;

  @NotNull
  private Long pageSize;

  private String realName;

  private String roleIds;

  /**
   * 热线接入方式 */
  public String getAnsweringMode() {
    return this.answeringMode;
  }

  /**
   * 热线接入方式 */
  public void setAnsweringMode(String answeringMode) {
    this.answeringMode = answeringMode;
  }

  /**
   * 数据权限id */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 在线扩展技能组id的json数组 */
  public String getChatExtendedGroupIds() {
    return this.chatExtendedGroupIds;
  }

  /**
   * 在线扩展技能组id的json数组 */
  public void setChatExtendedGroupIds(String chatExtendedGroupIds) {
    this.chatExtendedGroupIds = chatExtendedGroupIds;
  }

  /**
   * 在线技能组id的json数组 */
  public String getChatGroupIds() {
    return this.chatGroupIds;
  }

  /**
   * 在线技能组id的json数组 */
  public void setChatGroupIds(String chatGroupIds) {
    this.chatGroupIds = chatGroupIds;
  }

  /**
   * 在线服务等级的json数组 */
  public String getChatLevelIds() {
    return this.chatLevelIds;
  }

  /**
   * 在线服务等级的json数组 */
  public void setChatLevelIds(String chatLevelIds) {
    this.chatLevelIds = chatLevelIds;
  }

  /**
   * 邮箱 */
  public String getEmail() {
    return this.email;
  }

  /**
   * 邮箱 */
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * 热线扩展技能组id的json数组 */
  public String getHotlineGroupIds() {
    return this.hotlineGroupIds;
  }

  /**
   * 热线扩展技能组id的json数组 */
  public void setHotlineGroupIds(String hotlineGroupIds) {
    this.hotlineGroupIds = hotlineGroupIds;
  }

  /**
   * 查询结果的页码，起始值为 1，默认值为 1 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 查询结果的页码，起始值为 1，默认值为 1 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 分页查询时设置的每页记录数，最大值 100 行，默认为 10 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 分页查询时设置的每页记录数，最大值 100 行，默认为 10 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 姓名 */
  public String getRealName() {
    return this.realName;
  }

  /**
   * 姓名 */
  public void setRealName(String realName) {
    this.realName = realName;
  }

  /**
   * 角色id的json数组 */
  public String getRoleIds() {
    return this.roleIds;
  }

  /**
   * 角色id的json数组 */
  public void setRoleIds(String roleIds) {
    this.roleIds = roleIds;
  }
}
