//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.GetBuserviceAgentResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 查询一个客服
 */
public class GetBuserviceAgentRequest extends AntCloudProdProviderRequest<GetBuserviceAgentResponse> {
  private String dingtalkUserId;

  @NotNull
  private String id;

  private String jobNumber;

  private String loginName;

  /**
   * 钉钉user_id（来自钉钉的租户该字段非空） */
  public String getDingtalkUserId() {
    return this.dingtalkUserId;
  }

  /**
   * 钉钉user_id（来自钉钉的租户该字段非空） */
  public void setDingtalkUserId(String dingtalkUserId) {
    this.dingtalkUserId = dingtalkUserId;
  }

  /**
   * 客服id */
  public String getId() {
    return this.id;
  }

  /**
   * 客服id */
  public void setId(String id) {
    this.id = id;
  }

  /**
   * 工号 */
  public String getJobNumber() {
    return this.jobNumber;
  }

  /**
   * 工号 */
  public void setJobNumber(String jobNumber) {
    this.jobNumber = jobNumber;
  }

  /**
   * 客服登录账户 */
  public String getLoginName() {
    return this.loginName;
  }

  /**
   * 客服登录账户 */
  public void setLoginName(String loginName) {
    this.loginName = loginName;
  }
}
