//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.EvaluateRobotSessionResponse;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 评价机器人会话
 */
public class EvaluateRobotSessionRequest extends AntCloudProdProviderRequest<EvaluateRobotSessionResponse> {
  private String remark;

  @NotNull
  private String sessionId;

  @NotNull
  private Long vote;

  /**
   * 评价内容 */
  public String getRemark() {
    return this.remark;
  }

  /**
   * 评价内容 */
  public void setRemark(String remark) {
    this.remark = remark;
  }

  /**
   * 机器人会话ID */
  public String getSessionId() {
    return this.sessionId;
  }

  /**
   * 机器人会话ID */
  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }

  /**
   * 投票值 */
  public Long getVote() {
    return this.vote;
  }

  /**
   * 投票值 */
  public void setVote(Long vote) {
    this.vote = vote;
  }
}
