//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.DeleteCsmngNoticeResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 删除公告 */
public class DeleteCsmngNoticeRequest extends AntCloudProdProviderRequest<DeleteCsmngNoticeResponse> {
  private String ccsInstanceId;

  @NotNull
  private String id;

  /**
   * 数据权限id(云客服租户实例id)，如果为空，则为默认数据权限 */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(云客服租户实例id)，如果为空，则为默认数据权限 */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 公告ID */
  public String getId() {
    return this.id;
  }

  /**
   * 公告ID */
  public void setId(String id) {
    this.id = id;
  }
}
