//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.CreateRobotSessionResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 机器人会话创建
 */
public class CreateRobotSessionRequest extends AntCloudProdProviderRequest<CreateRobotSessionResponse> {
  @NotNull
  private String robotId;

  @NotNull
  private String sceneId;

  @NotNull
  private String visitorId;

  private String visitorIp;

  /**
   * 机器人ID */
  public String getRobotId() {
    return this.robotId;
  }

  /**
   * 机器人ID */
  public void setRobotId(String robotId) {
    this.robotId = robotId;
  }

  /**
   * 场景ID */
  public String getSceneId() {
    return this.sceneId;
  }

  /**
   * 场景ID */
  public void setSceneId(String sceneId) {
    this.sceneId = sceneId;
  }

  /**
   * 访客ID，由调用方提供，比如：微信用户id等 */
  public String getVisitorId() {
    return this.visitorId;
  }

  /**
   * 访客ID，由调用方提供，比如：微信用户id等 */
  public void setVisitorId(String visitorId) {
    this.visitorId = visitorId;
  }

  /**
   * 访客端的IP */
  public String getVisitorIp() {
    return this.visitorIp;
  }

  /**
   * 访客端的IP */
  public void setVisitorIp(String visitorIp) {
    this.visitorIp = visitorIp;
  }
}
