//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.CreateProcessTicketResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 工单创建
 */
public class CreateProcessTicketRequest extends AntCloudProdProviderRequest<CreateProcessTicketResponse> {
  private String ccsInstanceId;

  @NotNull
  private String creatorId;

  @NotNull
  private String customFields;

  private String description;

  @NotNull
  private String type;

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 创建者的用户id */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 创建者的用户id */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 工单的自定义表单内容 */
  public String getCustomFields() {
    return this.customFields;
  }

  /**
   * 工单的自定义表单内容 */
  public void setCustomFields(String customFields) {
    this.customFields = customFields;
  }

  /**
   * 工单描述信息 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 工单描述信息 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 工单类型 */
  public String getType() {
    return this.type;
  }

  /**
   * 工单类型 */
  public void setType(String type) {
    this.type = type;
  }
}
