//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.model.CampaignSchedule;
import cn.com.antcloud.api.provider.csc.v1_0.response.CreateHotlineCampaignResponse;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 外呼活动创建 */
public class CreateHotlineCampaignRequest extends AntCloudProdProviderRequest<CreateHotlineCampaignResponse> {
  private String callAgentScale;

  @NotNull
  private String hotlineGroupId;

  @NotNull
  private String ivrModuleId;

  private Long maxCallTimes;

  @NotNull
  private String name;

  @NotNull
  private List<CampaignSchedule> schedules;

  @NotNull
  private String terminationDay;

  @NotNull
  private String type;

  /**
   * 人员利用比例百分比: 0.01 ~ 1.00 之间的小数 */
  public String getCallAgentScale() {
    return this.callAgentScale;
  }

  /**
   * 人员利用比例百分比: 0.01 ~ 1.00 之间的小数 */
  public void setCallAgentScale(String callAgentScale) {
    this.callAgentScale = callAgentScale;
  }

  /**
   * 负责接听处理该外呼活动的热线坐席技能组id */
  public String getHotlineGroupId() {
    return this.hotlineGroupId;
  }

  /**
   * 负责接听处理该外呼活动的热线坐席技能组id */
  public void setHotlineGroupId(String hotlineGroupId) {
    this.hotlineGroupId = hotlineGroupId;
  }

  /**
   * IVR流程模块Id，智能外呼类型时必填 */
  public String getIvrModuleId() {
    return this.ivrModuleId;
  }

  /**
   * IVR流程模块Id，智能外呼类型时必填 */
  public void setIvrModuleId(String ivrModuleId) {
    this.ivrModuleId = ivrModuleId;
  }

  /**
   * 最大呼叫次数。当呼叫未接通后会重复呼叫，直到达到最大呼叫次数或接通 */
  public Long getMaxCallTimes() {
    return this.maxCallTimes;
  }

  /**
   * 最大呼叫次数。当呼叫未接通后会重复呼叫，直到达到最大呼叫次数或接通 */
  public void setMaxCallTimes(Long maxCallTimes) {
    this.maxCallTimes = maxCallTimes;
  }

  /**
   * 外呼活动名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 外呼活动名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 外呼活动时间安排，最多8个时间段 */
  public List<CampaignSchedule> getSchedules() {
    return this.schedules;
  }

  /**
   * 外呼活动时间安排，最多8个时间段 */
  public void setSchedules(List<CampaignSchedule> schedules) {
    this.schedules = schedules;
  }

  /**
   * 外呼活动截止日期，格式：yyyy-MM-dd，超过截止日期不再调度执行。 */
  public String getTerminationDay() {
    return this.terminationDay;
  }

  /**
   * 外呼活动截止日期，格式：yyyy-MM-dd，超过截止日期不再调度执行。 */
  public void setTerminationDay(String terminationDay) {
    this.terminationDay = terminationDay;
  }

  /**
   * 外呼活动类型:
   * PREDICTIVE：预测式外呼；
   * PREVIEW：预览式外呼；
   * IVR：ivr媒体外呼； */
  public String getType() {
    return this.type;
  }

  /**
   * 外呼活动类型:
   * PREDICTIVE：预测式外呼；
   * PREVIEW：预览式外呼；
   * IVR：ivr媒体外呼； */
  public void setType(String type) {
    this.type = type;
  }
}
