//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.CreateBuserviceRoleResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 创建角色
 */
public class CreateBuserviceRoleRequest extends AntCloudProdProviderRequest<CreateBuserviceRoleResponse> {
  private String creatorId;

  private String description;

  @NotNull
  private String functionIds;

  @NotNull
  private String name;

  /**
   * 创建人id */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 创建人id */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 角色描述 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 角色描述 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 角色关联额功能点id */
  public String getFunctionIds() {
    return this.functionIds;
  }

  /**
   * 角色关联额功能点id */
  public void setFunctionIds(String functionIds) {
    this.functionIds = functionIds;
  }

  /**
   * 角色名 */
  public String getName() {
    return this.name;
  }

  /**
   * 角色名 */
  public void setName(String name) {
    this.name = name;
  }
}
