//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.CountChatConversationOfflineResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 查询离线聊天会话个数 */
public class CountChatConversationOfflineRequest extends AntCloudProdProviderRequest<CountChatConversationOfflineResponse> {
  private String ccsInstanceId;

  @NotNull
  private String status;

  /**
   * 数据权限id(云客服租户实例id)，如果为空，则为默认数据权限 */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(云客服租户实例id)，如果为空，则为默认数据权限 */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * 会话状态：
   * UNREPLIED：未处理的离线会话 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 会话状态：
   * UNREPLIED：未处理的离线会话 */
  public void setStatus(String status) {
    this.status = status;
  }
}
