//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.CheckInspectAudioResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 语音文件质检。文件大小不超过128M，时长不超过1小时。
 */
public class CheckInspectAudioRequest extends AntCloudProdProviderRequest<CheckInspectAudioResponse> {
  @NotNull
  private String audioFormat;

  @NotNull
  private String resourceType;

  @NotNull
  private String resourceValue;

  /**
   * 语音文件的格式 */
  public String getAudioFormat() {
    return this.audioFormat;
  }

  /**
   * 语音文件的格式 */
  public void setAudioFormat(String audioFormat) {
    this.audioFormat = audioFormat;
  }

  /**
   * 语音类型 */
  public String getResourceType() {
    return this.resourceType;
  }

  /**
   * 语音类型 */
  public void setResourceType(String resourceType) {
    this.resourceType = resourceType;
  }

  /**
   * 资源值，当resource_type=OSS_FILE为OSS file key；当resource_type=URL为公网可访问的URL链接，链接仅支持HTTP */
  public String getResourceValue() {
    return this.resourceValue;
  }

  /**
   * 资源值，当resource_type=OSS_FILE为OSS file key；当resource_type=URL为公网可访问的URL链接，链接仅支持HTTP */
  public void setResourceValue(String resourceValue) {
    this.resourceValue = resourceValue;
  }
}
