//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.ChatRobotSessionResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 机器人对话
 */
public class ChatRobotSessionRequest extends AntCloudProdProviderRequest<ChatRobotSessionResponse> {
  private String intentionId;

  private String jsonFactors;

  private String knowledgeId;

  @NotNull
  private String sessionId;

  @NotNull
  private String utterance;

  /**
   * 意图管理中配置的意图id，如果指定了意图id，该请求直接进入该意图的多轮对话(DST) */
  public String getIntentionId() {
    return this.intentionId;
  }

  /**
   * 意图管理中配置的意图id，如果指定了意图id，该请求直接进入该意图的多轮对话(DST) */
  public void setIntentionId(String intentionId) {
    this.intentionId = intentionId;
  }

  /**
   * JSON格式的因子参数；意图-->因子管理中可使用 */
  public String getJsonFactors() {
    return this.jsonFactors;
  }

  /**
   * JSON格式的因子参数；意图-->因子管理中可使用 */
  public void setJsonFactors(String jsonFactors) {
    this.jsonFactors = jsonFactors;
  }

  /**
   * 知识库文章ID，如果有值，则机器人直接返回知识库文章内容 */
  public String getKnowledgeId() {
    return this.knowledgeId;
  }

  /**
   * 知识库文章ID，如果有值，则机器人直接返回知识库文章内容 */
  public void setKnowledgeId(String knowledgeId) {
    this.knowledgeId = knowledgeId;
  }

  /**
   * 机器人会话ID */
  public String getSessionId() {
    return this.sessionId;
  }

  /**
   * 机器人会话ID */
  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }

  /**
   * 提问内容 */
  public String getUtterance() {
    return this.utterance;
  }

  /**
   * 提问内容 */
  public void setUtterance(String utterance) {
    this.utterance = utterance;
  }
}
