//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.AddKbaseFeedbackResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 为帮助提供文章反馈接口，记录用户及小二对当前文章的评论等信息
 */
public class AddKbaseFeedbackRequest extends AntCloudProdProviderRequest<AddKbaseFeedbackResponse> {
  @NotNull
  private String articleId;

  private String content;

  @NotNull
  private String source;

  @NotNull
  private String type;

  /**
   * 文章ID */
  public String getArticleId() {
    return this.articleId;
  }

  /**
   * 文章ID */
  public void setArticleId(String articleId) {
    this.articleId = articleId;
  }

  /**
   * 反馈内容(type为评论时必填，type为点赞或点踩时不填) */
  public String getContent() {
    return this.content;
  }

  /**
   * 反馈内容(type为评论时必填，type为点赞或点踩时不填) */
  public void setContent(String content) {
    this.content = content;
  }

  /**
   * 来源场景，目前固定为HELP */
  public String getSource() {
    return this.source;
  }

  /**
   * 来源场景，目前固定为HELP */
  public void setSource(String source) {
    this.source = source;
  }

  /**
   * 反馈类型,FEEDBACK代表p评论，ISGOOD代表赞，NOGOOD代表踩 */
  public String getType() {
    return this.type;
  }

  /**
   * 反馈类型,FEEDBACK代表p评论，ISGOOD代表赞，NOGOOD代表踩 */
  public void setType(String type) {
    this.type = type;
  }
}
