//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.request;

import cn.com.antcloud.api.product.provider.AntCloudProdProviderRequest;
import cn.com.antcloud.api.provider.csc.v1_0.response.AddHotlineCampaignTaskResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 给外呼活动添加外呼任务 */
public class AddHotlineCampaignTaskRequest extends AntCloudProdProviderRequest<AddHotlineCampaignTaskResponse> {
  @NotNull
  private String calledNumber;

  @NotNull
  private String campaignId;

  @NotNull
  private String customerName;

  private String memo;

  private String outId;

  /**
   * 被叫号码 */
  public String getCalledNumber() {
    return this.calledNumber;
  }

  /**
   * 被叫号码 */
  public void setCalledNumber(String calledNumber) {
    this.calledNumber = calledNumber;
  }

  /**
   * 外呼活动id */
  public String getCampaignId() {
    return this.campaignId;
  }

  /**
   * 外呼活动id */
  public void setCampaignId(String campaignId) {
    this.campaignId = campaignId;
  }

  /**
   * 外呼对象客户的姓名 */
  public String getCustomerName() {
    return this.customerName;
  }

  /**
   * 外呼对象客户的姓名 */
  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  /**
   * 外呼任务备注信息 */
  public String getMemo() {
    return this.memo;
  }

  /**
   * 外呼任务备注信息 */
  public void setMemo(String memo) {
    this.memo = memo;
  }

  /**
   * 预留给调用方的业务id */
  public String getOutId() {
    return this.outId;
  }

  /**
   * 预留给调用方的业务id */
  public void setOutId(String outId) {
    this.outId = outId;
  }
}
