//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.String;

/**
 * 存储操作的访问策略，包含目标bucket名称、目标文件名的前缀 */
public class StorageAccessPolicy {
  private String bucketName;

  private String endpoint;

  private String prefix;

  /**
   * bucket名称，比如：指定的上传文件的oss bucket */
  public String getBucketName() {
    return this.bucketName;
  }

  /**
   * bucket名称，比如：指定的上传文件的oss bucket */
  public void setBucketName(String bucketName) {
    this.bucketName = bucketName;
  }

  /**
   * 用于上传文件的地址 */
  public String getEndpoint() {
    return this.endpoint;
  }

  /**
   * 用于上传文件的地址 */
  public void setEndpoint(String endpoint) {
    this.endpoint = endpoint;
  }

  /**
   * 文件名前缀，比如：指定的上传文件的oss prefix */
  public String getPrefix() {
    return this.prefix;
  }

  /**
   * 文件名前缀，比如：指定的上传文件的oss prefix */
  public void setPrefix(String prefix) {
    this.prefix = prefix;
  }
}
