//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.Long;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 云客服spi调用租户系统的详情，包括：耗时、method、参数、返回状态码、返回错误信息等信息 */
public class SpiLog {
  @NotNull
  private String ccsInstanceId;

  @NotNull
  private Long duration;

  private String parameter;

  private String resultCode;

  private String resultMessage;

  @NotNull
  private String spiEndpoint;

  @NotNull
  private String spiKey;

  @NotNull
  private String spiMethod;

  @NotNull
  private String spiRequestId;

  @NotNull
  private Date spiRequestTime;

  @NotNull
  private String spiVersion;

  @NotNull
  private String success;

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public String getCcsInstanceId() {
    return this.ccsInstanceId;
  }

  /**
   * 数据权限id(租户实例id)：ZPASFSCN。若未设值，则使用默认租户实例id */
  public void setCcsInstanceId(String ccsInstanceId) {
    this.ccsInstanceId = ccsInstanceId;
  }

  /**
   * SPI调用耗时，单位：毫秒 */
  public Long getDuration() {
    return this.duration;
  }

  /**
   * SPI调用耗时，单位：毫秒 */
  public void setDuration(Long duration) {
    this.duration = duration;
  }

  /**
   * SPI调用是否成功。true：调用成功；false：调用失败 */
  public String getParameter() {
    return this.parameter;
  }

  /**
   * SPI调用是否成功。true：调用成功；false：调用失败 */
  public void setParameter(String parameter) {
    this.parameter = parameter;
  }

  /**
   * spi调用返回的结果码。OK：调用成功；NOT_EXECUTE：因队列阻塞导致未调用；EXCEPTION：调用过程中抛出了未知异常，比如：超时，连接异常；其他值，由租户自行定义 */
  public String getResultCode() {
    return this.resultCode;
  }

  /**
   * spi调用返回的结果码。OK：调用成功；NOT_EXECUTE：因队列阻塞导致未调用；EXCEPTION：调用过程中抛出了未知异常，比如：超时，连接异常；其他值，由租户自行定义 */
  public void setResultCode(String resultCode) {
    this.resultCode = resultCode;
  }

  /**
   * spi调用返回的提示信息 */
  public String getResultMessage() {
    return this.resultMessage;
  }

  /**
   * spi调用返回的提示信息 */
  public void setResultMessage(String resultMessage) {
    this.resultMessage = resultMessage;
  }

  /**
   * SPI的调用地址，用户在SPI配置中配置的endpoint，不能带有参数 */
  public String getSpiEndpoint() {
    return this.spiEndpoint;
  }

  /**
   * SPI的调用地址，用户在SPI配置中配置的endpoint，不能带有参数 */
  public void setSpiEndpoint(String spiEndpoint) {
    this.spiEndpoint = spiEndpoint;
  }

  /**
   * SPI Key */
  public String getSpiKey() {
    return this.spiKey;
  }

  /**
   * SPI Key */
  public void setSpiKey(String spiKey) {
    this.spiKey = spiKey;
  }

  /**
   * SPI的方法 */
  public String getSpiMethod() {
    return this.spiMethod;
  }

  /**
   * SPI的方法 */
  public void setSpiMethod(String spiMethod) {
    this.spiMethod = spiMethod;
  }

  /**
   * SPI的请求ID */
  public String getSpiRequestId() {
    return this.spiRequestId;
  }

  /**
   * SPI的请求ID */
  public void setSpiRequestId(String spiRequestId) {
    this.spiRequestId = spiRequestId;
  }

  /**
   * 查询开始时间，按照ISO8601标准表示，比如：2018-12-24T15:38:17.824+08:00 */
  public Date getSpiRequestTime() {
    return this.spiRequestTime;
  }

  /**
   * 查询开始时间，按照ISO8601标准表示，比如：2018-12-24T15:38:17.824+08:00 */
  public void setSpiRequestTime(Date spiRequestTime) {
    this.spiRequestTime = spiRequestTime;
  }

  /**
   * SPI的版本 */
  public String getSpiVersion() {
    return this.spiVersion;
  }

  /**
   * SPI的版本 */
  public void setSpiVersion(String spiVersion) {
    this.spiVersion = spiVersion;
  }

  /**
   * SPI调用是否成功。true：调用成功；false：调用失败 */
  public String getSuccess() {
    return this.success;
  }

  /**
   * SPI调用是否成功。true：调用成功；false：调用失败 */
  public void setSuccess(String success) {
    this.success = success;
  }
}
