//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.csc.v1_0.model;

import java.lang.Long;
import java.lang.String;

/**
 * 聊天语句的分析结果 */
public class SentenceDetail {
  private String content;

  private String emotion;

  private Long endTime;

  private String speaker;

  private String speed;

  private Long startTime;

  /**
   * 语音对应的文本内容 */
  public String getContent() {
    return this.content;
  }

  /**
   * 语音对应的文本内容 */
  public void setContent(String content) {
    this.content = content;
  }

  /**
   * 情绪能量值1-10，值越高情绪越强烈 */
  public String getEmotion() {
    return this.emotion;
  }

  /**
   * 情绪能量值1-10，值越高情绪越强烈 */
  public void setEmotion(String emotion) {
    this.emotion = emotion;
  }

  /**
   * 该句的结束时间偏移，单位为毫秒 */
  public Long getEndTime() {
    return this.endTime;
  }

  /**
   * 该句的结束时间偏移，单位为毫秒 */
  public void setEndTime(Long endTime) {
    this.endTime = endTime;
  }

  /**
   * 说话人 */
  public String getSpeaker() {
    return this.speaker;
  }

  /**
   * 说话人 */
  public void setSpeaker(String speaker) {
    this.speaker = speaker;
  }

  /**
   * 本句的平均语速，单位：字/分钟 */
  public String getSpeed() {
    return this.speed;
  }

  /**
   * 本句的平均语速，单位：字/分钟 */
  public void setSpeed(String speed) {
    this.speed = speed;
  }

  /**
   * 该句的起始时间偏移，单位为毫秒 */
  public Long getStartTime() {
    return this.startTime;
  }

  /**
   * 该句的起始时间偏移，单位为毫秒 */
  public void setStartTime(Long startTime) {
    this.startTime = startTime;
  }
}
